package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * 数据权限模型
 * @Author: Paul Chan
 * @Date: 2020-04-23 10:56
 */
@Entity
@ApiModel("数据权限模型")
@Table(name="engine_dataview_auth")
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_auth" , comment = "数据视图之横向数据权限信息")
public class DataViewAuthEntity extends UuidEntity {
  private static final long serialVersionUID = -7376770930136929012L;

  /**
   * 对应的数据视图, 此处的数据视图可以为空
   */
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="data_view", columnDefinition = "varchar(255) COMMENT '对应的数据视图'")
  @SaturnColumn(description="对应的视图")
  private DataViewEntity dataView;

  /**
   * 权限名称
   */
  @SaturnColumn(description = "权限名称")
  @ApiModelProperty("权限名称")
  @Column(name = "name", nullable = false, columnDefinition = "varchar(255) COMMENT '权限名称'")
  private String name;

  /**
   * 权限编码
   */
  @SaturnColumn(description = "权限编码")
  @ApiModelProperty("权限编码")
  @Column(name = "code", nullable = false, unique = true, columnDefinition = "varchar(255) COMMENT '权限编码'")
  private String code;

  /**
   * 创建时间
   */
  @SaturnColumn(description = "创建时间")
  @ApiModelProperty("创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime(3) COMMENT '创建时间'")
  private Date createTime;

  /**
   * 横向权限
   */
  @OrderBy("sort_index")
  @SaturnColumn(description = "横向权限")
  @ApiModelProperty("横向权限")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "dataViewAuth")
  private Set<DataViewAuthHorizontalEntity> horizontalAuths;

  /**
   * 竖向权限
   */
  @OrderBy("sort_index")
  @SaturnColumn(description = "竖向权限")
  @ApiModelProperty("竖向权限")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "dataViewAuth")
  private Set<DataViewAuthVerticalEntity> verticalAuths;

  /**
   * 拦截器
   */
  @OrderBy("sort")
  @SaturnColumn(description = "拦截器")
  @ApiModelProperty("拦截器")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "dataViewAuth")
  private Set<DataViewAuthInterceptorEntity> interceptors;

  public DataViewEntity getDataView() {
    return dataView;
  }

  public void setDataView(DataViewEntity dataView) {
    this.dataView = dataView;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Set<DataViewAuthHorizontalEntity> getHorizontalAuths() {
    return horizontalAuths;
  }

  public void setHorizontalAuths(Set<DataViewAuthHorizontalEntity> horizontalAuths) {
    this.horizontalAuths = horizontalAuths;
  }

  public Set<DataViewAuthVerticalEntity> getVerticalAuths() {
    return verticalAuths;
  }

  public void setVerticalAuths(Set<DataViewAuthVerticalEntity> verticalAuths) {
    this.verticalAuths = verticalAuths;
  }

  public Set<DataViewAuthInterceptorEntity> getInterceptors() {
    return interceptors;
  }

  public void setInterceptors(Set<DataViewAuthInterceptorEntity> interceptors) {
    this.interceptors = interceptors;
  }
}
