package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

/**
 * 横向权限之权限领域
 */
@Entity
@Table(name="engine_dataview_auth_horizontal_relation", uniqueConstraints = {@UniqueConstraint(columnNames = {"auth_horizontal", "auth_relation_id"})})
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_auth_horizontal_relation" , comment = "横向权限之权限领域")
public class DataViewAuthHorizontalRelationEntity extends UuidEntity {
  private static final long serialVersionUID = 1L;
  /**
   * 横向数据权限
   */
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="auth_horizontal" , nullable=false, columnDefinition = "varchar(255) COMMENT '横向数据权限'")
  @SaturnColumn(description="横向数据权限")
  private DataViewAuthHorizontalEntity authHorizontal;
  /**
   * 横向权限领域
   */
  @Column(name="auth_relation_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '横向权限领域'")
  @SaturnColumn(description="横向权限领域")
  private String authRelationIds;
  /**
   * 排序字段
   */
  @Column(name="sort_index" , nullable=false , columnDefinition = "int(11) COMMENT '排序字段'")
  @SaturnColumn(description="横向权限排序")
  private Integer sortIndex;

  /**
   * 横向权限领域数据
   */
  @Transient
  @SaturnColumn(description="横向权限领域数据")
  private UuidVo relation;

  public DataViewAuthHorizontalEntity getAuthHorizontal() {
    return authHorizontal;
  }

  public void setAuthHorizontal(DataViewAuthHorizontalEntity authHorizontal) {
    this.authHorizontal = authHorizontal;
  }

  public String getAuthRelationIds() {
    return authRelationIds;
  }

  public void setAuthRelationIds(String authRelationIds) {
    this.authRelationIds = authRelationIds;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public UuidVo getRelation() {
    return relation;
  }

  public void setRelation(UuidVo relation) {
    this.relation = relation;
  }
}
