package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 数据视图权限拦截器
 *
 * @Author: Paul Chan
 * @Date: 2019-12-23 10:11
 */
@Entity
@ApiModel("数据视图权限拦截器")
@Table(name = "engine_dataview_auth_interceptor")
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_auth_interceptor", comment = "数据视图权限拦截器")
public class DataViewAuthInterceptorEntity extends UuidEntity {
  private static final long serialVersionUID = -9173977570240129834L;

  /**
   * 数据视图权限
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "dataview_auth_id", nullable = false, columnDefinition = "varchar(255) COMMENT '数据视图权限'")
  @SaturnColumn(description = "数据视图权限")
  private DataViewAuthEntity dataViewAuth;

  /**
   * 拦截器类类型,0:java类路径，1：spring bean
   */
  @ApiModelProperty("拦截器类类型,0:java类路径，1：bean名称")
  @SaturnColumn(description = "拦截器类类型,0:java类路径，1：bean名称")
  @Column(name = "class_type", nullable = false, columnDefinition = "int(11) default 0 COMMENT '拦截器类类型,0:java类路径，1：bean名称'")
  private Integer classType;

  /**
   * 拦截器
   */
  @ApiModelProperty("拦截器")
  @SaturnColumn(description = "拦截器")
  @Column(name = "interceptor", nullable = false, columnDefinition = "varchar(255) COMMENT '拦截器'")
  private String interceptor;

  /**
   * 排序
   */
  @ApiModelProperty("排序")
  @SaturnColumn(description = "排序")
  @Column(name = "sort", nullable = false, columnDefinition = "int(11) COMMENT '排序'")
  private Integer sort;

  public Integer getClassType() {
    return classType;
  }

  public void setClassType(Integer classType) {
    this.classType = classType;
  }

  public String getInterceptor() {
    return interceptor;
  }

  public void setInterceptor(String interceptor) {
    this.interceptor = interceptor;
  }

  public DataViewAuthEntity getDataViewAuth() {
    return dataViewAuth;
  }

  public void setDataViewAuth(DataViewAuthEntity dataViewAuth) {
    this.dataViewAuth = dataViewAuth;
  }

  public Integer getSort() {
    return sort;
  }

  public void setSort(Integer sort) {
    this.sort = sort;
  }
}
