package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.util.Date;

/**
 * 技术中台，周期性或一次性动态任务的执行日志
 * @author yinwenjie
 */
@ApiModel(value = "DynamicTaskSchedulerLogEntity", description = "技术中台，周期性或一次性动态任务的执行日志")
@Entity
@Table(name = "engine_dynamic_task_log")
@org.hibernate.annotations.Table(appliesTo = "engine_dynamic_task_log" , comment = "技术中台，周期性或一次性动态任务的执行日志")
public class DynamicTaskSchedulerLogEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 5631381311388517154L;
  /**
   * 对应的动态日志
   */
  @ApiModelProperty(name="dynamicTaskScheduler" , value="对应的动态日志", required=true)
  @ManyToOne(fetch = FetchType.LAZY , targetEntity = DynamicTaskSchedulerEntity.class)
  @JoinColumn(name = "dynamic_task" , nullable = false, columnDefinition = "varchar(255) COMMENT '对应的动态日志'")
  @SaturnColumn(description="对应的动态日志")
  private DynamicTaskSchedulerEntity  dynamicTaskScheduler;
  /**
   * 执行开始时间
   */
  @ApiModelProperty(name="startTime" , value="执行开始时间", required=true)
  @Column(name = "start_time" , nullable = false, columnDefinition = "datetime COMMENT '对应的动态日志'")
  @SaturnColumn(description="执行开始时间")
  private Date startTime;
  /**
   * 执行结束时间
   */
  @ApiModelProperty(name="endTime" , value="执行结束时间", required=true)
  @Column(name = "end_time" , nullable = false, columnDefinition = "datetime COMMENT '对应的动态日志'")
  @SaturnColumn(description="执行结束时间")
  private Date endTime;
  /**
   * 执行是否成功
   */
  @ApiModelProperty(name="success" , value="执行是否成功", required=true)
  @Column(name = "is_success" , nullable = false, columnDefinition = "bit(1) COMMENT '对应的动态日志'")
  @SaturnColumn(description="执行是否成功")
  private Boolean success;
  /**
   * 可能的错误日志
   */
  @ApiModelProperty(name="errorContents" , value="可能的错误日志", required=false)
  @Column(name = "error_contents" , length = 512 , nullable = true, columnDefinition = "varchar(512) COMMENT '对应的动态日志'")
  @SaturnColumn(description="可能的错误日志")
  private String errorContents;
  public DynamicTaskSchedulerEntity getDynamicTaskScheduler() {
    return dynamicTaskScheduler;
  }
  public void setDynamicTaskScheduler(DynamicTaskSchedulerEntity dynamicTaskScheduler) {
    this.dynamicTaskScheduler = dynamicTaskScheduler;
  }
  public Date getStartTime() {
    return startTime;
  }
  public void setStartTime(Date startTime) {
    this.startTime = startTime;
  }
  public Date getEndTime() {
    return endTime;
  }
  public void setEndTime(Date endTime) {
    this.endTime = endTime;
  }
  public Boolean getSuccess() {
    return success;
  }
  public void setSuccess(Boolean success) {
    this.success = success;
  }
  public String getErrorContents() {
    return errorContents;
  }
  public void setErrorContents(String errorContents) {
    this.errorContents = errorContents;
  }
}