package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.user.common.vo.UserVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 数据迁移导出记录实体
 * @Author: Paul Chan
 * @Date: 2020-05-18 15:01
 */
@Entity
@ApiModel("数据迁移导出记录实体")
@Table(name = "engine_core_migrate_export")
@org.hibernate.annotations.Table(appliesTo = "engine_core_migrate_export", comment = "数据迁移导出记录")
public class MigrateExportEntity extends UuidEntity {
  private static final long serialVersionUID = -4918998693648966109L;

  /**
   * 数据类型：1:编码规则，2：数据视图，3：全局参数，4：数据字典，5：远端服务源，6：表单模版，7：列表模版，8：全局函数
   */
  @Column(name = "data_type", nullable = false, columnDefinition = "int(11) COMMENT '1:编码规则，2：数据视图，3：全局参数，" +
      "4：数据字典，5：远端服务源，6：表单模版，7：列表模版，8：全局函数'")
  @ApiModelProperty("数据类型：1:编码规则，2：数据视图，3：全局参数，4：数据字典，5：远端服务源，6：表单模版，7：列表模版，8：全局函数")
  @SaturnColumn(description = "数据类型：1:编码规则，2：数据视图，3：全局参数，4：数据字典，5：远端服务源，6：表单模版，7：列表模版，8：全局函数")
  private Integer dataType;

  /**
   * 创建者账号
   */
  @ApiModelProperty("创建者账号")
  @SaturnColumn(description = "创建者账号")
  @Column(name = "creator", nullable = false, columnDefinition = "varchar(255) COMMENT '创建者账号'")
  private String creator;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @SaturnColumn(description = "创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime(3) COMMENT '创建时间'")
  private Date createTime;

  /**
   * 导出数据项，如果没有执行数据项，则表示导出所有数据
   */
  @ApiModelProperty("导出数据项")
  @SaturnColumn(description = "导出数据项")
  @Column(name = "datas", columnDefinition = "varchar(3000) COMMENT '导出数据项'")
  private String datas;

  /**
   * 创建用户
   */
  @Transient
  @ApiModelProperty("创建用户")
  @SaturnColumn(description = "创建用户")
  private UserVo createUser;

  /**
   * 项目名
   */
  @ApiModelProperty("项目名")
  @SaturnColumn(description = "项目名")
  @Column(name = "project_name", length = 128, columnDefinition = "varchar(128) default '' COMMENT '项目名'")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public Integer getDataType() {
    return dataType;
  }

  public void setDataType(Integer dataType) {
    this.dataType = dataType;
  }

  public String getCreator() {
    return creator;
  }

  public void setCreator(String creator) {
    this.creator = creator;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getDatas() {
    return datas;
  }

  public void setDatas(String datas) {
    this.datas = datas;
  }

  public UserVo getCreateUser() {
    return createUser;
  }

  public void setCreateUser(UserVo createUser) {
    this.createUser = createUser;
  }
}
