package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import javax.persistence.Table;

/**
 * @Author: Paul Chan
 * @Date: 2020-05-13 14:48
 */
@Entity
@ApiModel("迁入文件保存实体")
@Table(name = "engine_core_migrate_import_detail")
@org.hibernate.annotations.Table(appliesTo = "engine_core_migrate_import_detail", comment = "核心模块数据的导出导入详情")
public class MigrateImportDetailEntity extends UuidEntity {
  private static final long serialVersionUID = 5059647359349063896L;

  /**
   * 导入记录
   */
  @ApiModelProperty("导入记录")
  @SaturnColumn(description = "导入记录")
  @OneToOne(fetch = FetchType.LAZY, mappedBy = "detail")
  private MigrateImportEntity migrateImport;

  /**
   * 新增的条数
   */
  @ApiModelProperty("新增的条数")
  @SaturnColumn(description = "新增的条数")
  @Column(name = "create_count", nullable = false, columnDefinition = "int(11) COMMENT '新增的条数'")
  private Integer createCount;

  /**
   * 更新的条数
   */
  @ApiModelProperty("更新的条数")
  @SaturnColumn(description = "更新的条数")
  @Column(name = "update_count", nullable = false, columnDefinition = "int(11) COMMENT '更新的条数'")
  private Integer updateCount;

  /**
   * 忽略的条数
   */
  @ApiModelProperty("忽略的条数")
  @SaturnColumn(description = "忽略的条数")
  @Column(name = "ignore_count", nullable = false, columnDefinition = "int(11) COMMENT '忽略的条数'")
  private Integer ignoreCount;

  /**
   * 总条数
   */
  @ApiModelProperty("总条数")
  @SaturnColumn(description = "总条数")
  @Column(name = "total_count", nullable = false, columnDefinition = "int(11) COMMENT '总条数'")
  private Integer totalCount;

  /**
   * 执行日志
   */
  @ApiModelProperty("执行日志")
  @SaturnColumn(description = "执行日志")
  @Column(name = "execute_log", nullable = false, columnDefinition = "text(0) COMMENT '执行日志'")
  private String executeLog;

  public MigrateImportEntity getMigrateImport() {
    return migrateImport;
  }

  public void setMigrateImport(MigrateImportEntity migrateImport) {
    this.migrateImport = migrateImport;
  }

  public Integer getCreateCount() {
    return createCount;
  }

  public void setCreateCount(Integer createCount) {
    this.createCount = createCount;
  }

  public Integer getUpdateCount() {
    return updateCount;
  }

  public void setUpdateCount(Integer updateCount) {
    this.updateCount = updateCount;
  }

  public Integer getTotalCount() {
    return totalCount;
  }

  public void setTotalCount(Integer totalCount) {
    this.totalCount = totalCount;
  }

  public String getExecuteLog() {
    return executeLog;
  }

  public void setExecuteLog(String executeLog) {
    this.executeLog = executeLog;
  }

  public Integer getIgnoreCount() {
    return ignoreCount;
  }

  public void setIgnoreCount(Integer ignoreCount) {
    this.ignoreCount = ignoreCount;
  }

}
