package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;

/**
 * RemoteServiceEntity
 * @description: 远端服务源
 * @author: yanwe
 * @date: 05/May/2019 17:23
 */
@Entity
@Table(name = "engine_remote_service")
@org.hibernate.annotations.Table(appliesTo = "engine_remote_service" , comment = "远端服务源")
public class RemoteServiceEntity extends UuidEntity {

  private static final long serialVersionUID = 18161764564290358L;

  /**
   * 远端服务源业务号，唯一编号
   */
  @ApiModelProperty(name = "code", value = "远端服务源业务号，唯一编号", required = true)
  @Column(name = "code", nullable = false , unique = true, columnDefinition = "varchar(255) COMMENT '远端服务源业务号，唯一编号'")
  @SaturnColumn(description = "远端服务源业务号，唯一编号")
  private String code;
  
  @ApiModelProperty(name = "remoteServiceType", value = "远端服务源类型，0:自定义HTTP调用地址; 1:client形式的spring cloud; 2: 非client形式的spring cloud", required = true)
  @Column(name = "remote_service_type", nullable = false, columnDefinition = "int(11) COMMENT '远端服务源类型，0:自定义HTTP调用地址; 1:client形式的spring cloud; 2: 非client形式的spring cloud'")
  @SaturnColumn(description = "远端服务源类型，0:自定义HTTP调用地址; 1:client形式的spring cloud; 2: 非client形式的spring cloud")
  private Integer remoteServiceType;

  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "remote_service_address_id", columnDefinition = "varchar(255) COMMENT '所选择的远端调用源地址'")
  @SaturnColumn(description = "所选择的远端调用源地址")
  private RemoteServiceAddressEntity remoteServiceAddress;

  @ApiModelProperty(name = "requestURL", value = "服务地址，相对地址", required = true)
  @Column(name = "request_url", nullable = false, columnDefinition = "varchar(255) COMMENT '服务地址，相对地址'")
  @SaturnColumn(description = "服务地址，相对地址")
  private String requestURL;

  @ApiModelProperty(name = "remoteServiceDesc", value = "远端服务描述")
  @Column(name = "remote_service_desc", columnDefinition = "varchar(255) COMMENT '远端服务描述'")
  @SaturnColumn(description = "远端服务描述")
  private String remoteServiceDesc;

  @ApiModelProperty(name = "requestMethod", value = "调用方式，可选择POST,GET,PATCH等", required = true)
  @Column(name = "request_method", nullable = false, length = 10, columnDefinition = "varchar(10) COMMENT '调用方式，可选择POST,GET,PATCH等'")
  @SaturnColumn(description = "调用方式，可选择POST,GET,PATCH等")
  private String requestMethod;

  @ApiModelProperty(name = "requestAccept", value = "接受的回应内容类型，目前只有application/json", required = true)
  @Column(name = "request_accept", nullable = false, length = 50, columnDefinition = "varchar(50) COMMENT '接受的回应内容类型，目前只有application/json'")
  @SaturnColumn(description = "接受的回应内容类型，目前只有application/json")
  private String requestAccept = "application/json";

  @ApiModelProperty(name = "acceptContentType", value = "接受内容类型设定，目前只有一种：application/json;charset=UTF-8", required = true)
  @Column(name = "accept_content_type", nullable = false, length = 50, columnDefinition = "varchar(50) COMMENT '接受内容类型设定，目前只有一种：application/json;charset=UTF-8'")
  @SaturnColumn(description = "接受内容类型设定，目前只有一种：application/json;charset=UTF-8")
  private String acceptContentType = "application/json;charset=UTF-8";

  @ApiModelProperty(name = "jsonName", value = "重命名后的文件名（包括后缀）", required = true)
  @Column(name = "json_name", nullable = false, columnDefinition = "varchar(255) COMMENT '重命名后的文件名（包括后缀）'")
  @SaturnColumn(description = "重命名后的文件名（包括后缀）")
  private String jsonName;

  @ApiModelProperty(name = "jsonRelativePath", value = "json文件的相对路径（包括已被重命名的，保证唯一性的完整文件名）", required = true)
  @Column(name = "json_relative_path", nullable = false, columnDefinition = "varchar(255) COMMENT 'json文件的相对路径（包括已被重命名的，保证唯一性的完整文件名'")
  @SaturnColumn(description = "文件的相对路径")
  private String jsonRelativePath;

  @ApiModelProperty(name = "remoteServiceStatus", value = "启用状态,1:启用，0：禁用")
  @Column(name = "remote_service_status", columnDefinition = "int(11) COMMENT '启用状态,1:启用，0：禁用'")
  @SaturnColumn(description = "启用状态,1:启用，0：禁用")
  private Integer remoteServiceStatus;

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public Integer getRemoteServiceType() {
    return remoteServiceType;
  }

  public void setRemoteServiceType(Integer remoteServiceType) {
    this.remoteServiceType = remoteServiceType;
  }

  public RemoteServiceAddressEntity getRemoteServiceAddress() {
    return remoteServiceAddress;
  }

  public void setRemoteServiceAddress(RemoteServiceAddressEntity remoteServiceAddress) {
    this.remoteServiceAddress = remoteServiceAddress;
  }

  public String getRequestURL() {
    return requestURL;
  }

  public void setRequestURL(String requestURL) {
    this.requestURL = requestURL;
  }

  public String getRequestMethod() {
    return requestMethod;
  }

  public void setRequestMethod(String requestMethod) {
    this.requestMethod = requestMethod;
  }

  public String getRequestAccept() {
    return requestAccept;
  }

  public void setRequestAccept(String requestAccept) {
    this.requestAccept = requestAccept;
  }

  public String getAcceptContentType() {
    return acceptContentType;
  }

  public void setAcceptContentType(String acceptContentType) {
    this.acceptContentType = acceptContentType;
  }

  public java.lang.String getJsonName() {
    return jsonName;
  }

  public void setJsonName(java.lang.String jsonName) {
    this.jsonName = jsonName;
  }

  public java.lang.String getJsonRelativePath() {
    return jsonRelativePath;
  }

  public void setJsonRelativePath(java.lang.String jsonRelativePath) {
    this.jsonRelativePath = jsonRelativePath;
  }

  public String getRemoteServiceDesc() {
    return remoteServiceDesc;
  }

  public void setRemoteServiceDesc(String remoteServiceDesc) {
    this.remoteServiceDesc = remoteServiceDesc;
  }

  public Integer getRemoteServiceStatus() {
    return remoteServiceStatus;
  }

  public void setRemoteServiceStatus(Integer remoteServiceStatus) {
    this.remoteServiceStatus = remoteServiceStatus;
  }
}
