package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/** @Author: Paul Chan @Date: 2019-05-10 13:43 @Description: 脚本持久类 */
@ApiModel(value = "ScriptEntity", description = "脚本持久类")
@Entity
@Table(name = "engine_script")
@org.hibernate.annotations.Table(appliesTo = "engine_script" , comment = "脚本持久类")
public class ScriptEntity extends UuidOpEntity {
  private static final long serialVersionUID = 7572307353320487071L;
  /** 名字唯一 */
  @ApiModelProperty(name = "name", value = "名字唯一", required = true)
  @Column(name = "name", nullable = false, length = 255, unique = true, columnDefinition = "varchar(255) COMMENT '名字唯一'")
  @SaturnColumn(description = "名字唯一")
  private String name;
  /** 脚本的md5编码 */
  @ApiModelProperty(name = "md5Code", value = "脚本的md5编码")
  @Column(name = "md5_code", length = 128, columnDefinition = "varchar(128) COMMENT '脚本的md5编码'")
  @SaturnColumn(description = "脚本的md5编码")
  private String md5Code;
  /** 脚本语言 */
  @ApiModelProperty(name = "language", value = "脚本语言", required = true)
  @Column(name = "language", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '脚本语言'")
  @SaturnColumn(description = "脚本语言")
  private String language;
  /** 文件的目录 */
  @ApiModelProperty(name = "fileCode", value = "文件的目录", required = true)
  @Column(name = "file_code", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '文件的目录'")
  @SaturnColumn(description = "文件的目录")
  private String fileCode;
  /** 文件名 */
  @ApiModelProperty(name = "fileName", value = "文件名", required = true)
  @Column(name = "file_name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '文件名'")
  @SaturnColumn(description = "文件名")
  private String fileName;
  /** 脚本持久类描述 */
  @ApiModelProperty(name = "description", value = "脚本持久类描述", required = true)
  @Column(name = "description", length = 512, columnDefinition = "varchar(512) COMMENT '脚本持久类描述'")
  @SaturnColumn(description = "脚本持久类描述")
  private String description;

  /**
   * 项目名
   */
  @ApiModelProperty("项目名")
  @SaturnColumn(description = "项目名")
  @Column(name = "project_name", length = 128, columnDefinition = "varchar(128) default '' COMMENT '项目名'")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getMd5Code() {
    return md5Code;
  }

  public void setMd5Code(String md5Code) {
    this.md5Code = md5Code;
  }

  public String getLanguage() {
    return language;
  }

  public void setLanguage(String language) {
    this.language = language;
  }

  public String getFileCode() {
    return fileCode;
  }

  public void setFileCode(String fileCode) {
    this.fileCode = fileCode;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }
}
