package com.bizunited.platform.core.entity.log;

import com.bizunited.platform.core.entity.UuidOpEntity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;

import javax.persistence.*;

/**
 * @Description: 日志字段描述映射Entity
 * @Date 2020/8/7 16:37
 */
@Entity
@Table(name = "engine_logger_field_mapping" ,
        uniqueConstraints = {@UniqueConstraint(columnNames = {"application_name", "field_name"})},
        indexes = {@Index(columnList = "application_name, field_name")})
@ApiModel(value = "LoggerInfoEntity", description = "日志字段描述映射信息")
public class LoggerFiledMappingEntity extends UuidOpEntity {

    private static final long serialVersionUID = -6645173888906566037L;

    /**
     * 应用名称
     */
    @Column(name="application_name" , nullable = false, length=255, columnDefinition = "varchar(255) COMMENT '应用名称'")
    @SaturnColumn(description="应用名称")
    private String applicationName;

    /**
     * 语言，默认CH
     */
    @Column(name="language" , nullable = false, length=64, columnDefinition = "varchar(64) COMMENT '语言，默认CH'")
    @SaturnColumn(description="语言，默认CH")
    private String language;

    /**
     * 英文字段名
     */
    @Column(name="field_name" , nullable = false, length=64, columnDefinition = "varchar(64) COMMENT '英文字段名'")
    @SaturnColumn(description="英文字段名")
    private String fieldName;

    /**
     * 映射方式 0--文本，1--字典表
     */
    @Column(name="mapping_type" , nullable = false, columnDefinition = "int COMMENT '映射方式0--文本,1--字典表'")
    @SaturnColumn(description="映射方式 0--文本，1--字典表")
    private Integer mappingType;

    /**
     * 字段描述
     */
    @Column(name="field_desc", length=255, columnDefinition = "varchar(255) COMMENT '字段描述'")
    @SaturnColumn(description="字段描述")
    private String fieldDesc;

    /**
     * 字典表code
     */
    @Column(name="dict_code", length=255, columnDefinition = "varchar(255) COMMENT '字典表code'")
    @SaturnColumn(description="字典表code")
    private String dictCode;



    public String getApplicationName() {
        return applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Integer getMappingType() {
        return mappingType;
    }

    public void setMappingType(Integer mappingType) {
        this.mappingType = mappingType;
    }

    public String getFieldDesc() {
        return fieldDesc;
    }

    public void setFieldDesc(String fieldDesc) {
        this.fieldDesc = fieldDesc;
    }

    public String getDictCode() {
        return dictCode;
    }

    public void setDictCode(String dictCode) {
        this.dictCode = dictCode;
    }
}
