package com.bizunited.platform.core.entity.log;


import com.bizunited.platform.core.entity.UuidOpEntity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 操作日志模板
 * @author yinwenjie
 */
@Entity
@Table(name = "engine_logger_template")
@ApiModel(value = "LoggerTemplateEntity", description = "日志结构模板")
public class LoggerTemplateEntity extends UuidOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -525665845125654269L;
  
  // ===== 以下是日志模板的基础信息
  /**
   * 模板名称
   */
  @Column(name = "name", length = 255, nullable = false)
  @ApiModelProperty(name = "name", value = "模板名称", required = true)
  @SaturnColumn(description = "模板名称")
  private String name;

  /**
   * 模板编号，唯一的编号，必须有
   */
  @Column(name = "code", length = 255, nullable = false, unique = true)
  @ApiModelProperty(name = "code", value = "模板编号，唯一的编号，必须有", required = true)
  @SaturnColumn(description = "模板编号，唯一的编号，必须有")
  private String code;
  /**
   * 操作类型：create、update、disable、enable、change、solve、assign等等，可以自行添加
   * 但是只能是英文
   */
  @Column(name = "type", nullable = false)
  @ApiModelProperty(name = "type", value = "操作类型，可以自行添加，但是只能是英文", required = true)
  @SaturnColumn(description = "操作类型，可以自行添加，但是只能是英文")
  private String type;
  /**
   * 业务模块，可以随便编写，但必须是英文
   */
  @Column(name = "module", nullable = false)
  @ApiModelProperty(name = "module", value = "业务模块，可以随便编写，但必须是英文", required = true)
  @SaturnColumn(description = "业务模块，可以随便编写，但必须是英文")
  private String module;
  /**
   * 完整的被拦截的方法名
   */
  @Column(name = "method_name", length = 255, nullable = false, unique = true)
  @ApiModelProperty(name = "methodName", value = "完整的被拦截的方法名", required = true)
  @SaturnColumn(description = "完整的被拦截的方法名")
  private String methodName;
  /**
   * 查询数据详情时，使用该方法的第几个参数作为入参
   */
  @Column(name = "method_param_Index", nullable = false)
  @ApiModelProperty(name = "methodParamIndex", value = "查询数据详情时，使用该方法的第几个参数作为入参", required = true)
  @SaturnColumn(description = "查询数据详情时，使用该方法的第几个参数作为入参")
  private Integer methodParamIndex = 0;
  
  /**
   * 如果指定的入参是一个对象，那么可以通过这个属性，指定用于在预查询、后置查询中，使用的“数据唯一标识”的依据属性
   */
  @Column(name = "method_param_property", nullable = true)
  @ApiModelProperty(name = "methodParamProperty", value = "可以指定用于在预查询、后置查询中，使用的“数据唯一标识”的依据属性", required = false)
  @SaturnColumn(description = "可以指定用于在预查询、后置查询中，使用的“数据唯一标识”的依据属性")
  private String methodParamProperty;
  /**
   * 日志信息表达式，
   * 内置支持：{user}当前操作者用户名(可能是匿名账户)，{time}操作时间，
   * {pre.XXXX}对象为预制查询结果的对象
   * {last.XXXX}对象为可能的后置查询结果的对象
   * 
   * {user} 在 {time} 对{pre.taskname}的需求做了禁用操作
   */
  @Column(name = "expression", nullable = false)
  @ApiModelProperty(name = "expression", value = "日志信息表达式", required = true)
  @SaturnColumn(description = "日志信息表达式")
  private String expression;
  
  /**
   * 该日志模板是否需要进行明细比较
   * 如果需要进行明细比较，则前置查询和后置查询必须都要设定
   */
  @Column(name = "compare", nullable = false)
  @ApiModelProperty(name = "compare", value = "该日志模板是否需要进行明细比较", required = true)
  @SaturnColumn(description = "该日志模板是否需要进行明细比较")
  private Boolean compare = false;
  
  // =================== 以下配置为选配的预查询信息
  
  /**
   * 进行预查询的bean组件信息（一般为bean组件名）
   */
  @Column(name = "pre_query_component", nullable = true)
  @ApiModelProperty(name = "preQueryComponent", value = "进行预查询的bean组件信息", required = false)
  @SaturnColumn(description = "进行预查询的bean组件信息")
  private String preQueryComponent = "";
  /**
   * 进行预查询的bean组件的方法名
   * 该方法将使用日志相关方法第methodParamIndex个参数作为指定对象的查询入参
   */
  @Column(name = "pre_query_method", nullable = true)
  @ApiModelProperty(name = "preQueryMethod", value = "进行预查询的bean组件的方法名", required = false)
  @SaturnColumn(description = "进行预查询的bean组件的方法名")
  private String preQueryMethod;
  /**
   * 预查询时，可以使用该属性指定这个业务对象的哪些直接或间接属性需要进行返回</p>
   * 例如:"buyer,product"。表示这个返回对象中的两个关联属性对象buyer,product需要返回
   */
  @Column(name = "pre_return_filter", nullable = true)
  @ApiModelProperty(name = "preReturnFilter", value = "预查询时，可以使用该属性指定这个业务对象的哪些直接或间接属性需要进行返回", required = false)
  @SaturnColumn(description = "预查询时，可以使用该属性指定这个业务对象的哪些直接或间接属性需要进行返回")
  private String preReturnFilter = "";
  
  // =============== 以下为选配的后置查询信息
  
  /**
   * 进行后置查询的bean组件信息（一般为bean组件名）
   */
  @Column(name = "last_query_component", nullable=true)
  @ApiModelProperty(name = "lastQueryComponent", value = "进行后置查询的bean组件信息（一般为bean组件名）", required = false)
  @SaturnColumn(description = "进行后置查询的bean组件信息（一般为bean组件名）")
  private String lastQueryComponent = "";
  /**
   * 进行后置查询的bean组件的方法名
   */
  @Column(name = "last_query_method", nullable = true)
  @ApiModelProperty(name = "lastQueryMethod", value = "进行后置查询的bean组件的方法名", required = false)
  @SaturnColumn(description = "进行后置查询的bean组件的方法名")
  private String lastQueryMethod = "";
  /**
   * 后置查询时，可以使用该属性指定这个业务对象的哪些直接或间接属性需要进行返回
   */
  @Column(name = "last_return_filter", nullable = true)
  @ApiModelProperty(name = "lastReturnFilter", value = "后置查询时，可以使用该属性指定这个业务对象的哪些直接或间接属性需要进行返回", required = false)
  @SaturnColumn(description = "后置查询时，可以使用该属性指定这个业务对象的哪些直接或间接属性需要进行返回")
  private String lastReturnFilter = "";

  /**
   * 模板状态（1--启用，0--禁用）
   */
  @Column(name = "state", nullable = false)
  @ApiModelProperty(name = "state", value = "模板状态（1--启用，0--禁用）", required = true)
  @SaturnColumn(description = "模板状态（1--启用，0--禁用）")
  private Integer state;

  
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getMethodName() {
    return methodName;
  }
  public void setMethodName(String methodName) {
    this.methodName = methodName;
  }
  public Integer getMethodParamIndex() {
    return methodParamIndex;
  }
  public void setMethodParamIndex(Integer methodParamIndex) {
    this.methodParamIndex = methodParamIndex;
  }
  public String getExpression() {
    return expression;
  }
  public void setExpression(String expression) {
    this.expression = expression;
  }
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }
  public String getModule() {
    return module;
  }
  public void setModule(String module) {
    this.module = module;
  }
  public Boolean getCompare() {
    return compare;
  }
  public void setCompare(Boolean compare) {
    this.compare = compare;
  }
  public String getPreQueryComponent() {
    return preQueryComponent;
  }
  public void setPreQueryComponent(String preQueryComponent) {
    this.preQueryComponent = preQueryComponent;
  }
  public String getPreQueryMethod() {
    return preQueryMethod;
  }
  public void setPreQueryMethod(String preQueryMethod) {
    this.preQueryMethod = preQueryMethod;
  }
  public String getPreReturnFilter() {
    return preReturnFilter;
  }
  public void setPreReturnFilter(String preReturnFilter) {
    this.preReturnFilter = preReturnFilter;
  }
  public String getLastQueryComponent() {
    return lastQueryComponent;
  }
  public void setLastQueryComponent(String lastQueryComponent) {
    this.lastQueryComponent = lastQueryComponent;
  }
  public String getLastQueryMethod() {
    return lastQueryMethod;
  }
  public void setLastQueryMethod(String lastQueryMethod) {
    this.lastQueryMethod = lastQueryMethod;
  }
  public String getLastReturnFilter() {
    return lastReturnFilter;
  }
  public void setLastReturnFilter(String lastReturnFilter) {
    this.lastReturnFilter = lastReturnFilter;
  }
  public String getMethodParamProperty() {
    return methodParamProperty;
  }
  public void setMethodParamProperty(String methodParamProperty) {
    this.methodParamProperty = methodParamProperty;
  }
  public Integer getState() {
    return state;
  }

  public void setState(Integer state) {
    this.state = state;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }
}