package com.bizunited.platform.core.interceptor;

/**
 * 数据视图拦截器接口，此拦截器作用于数据视图执行时sql前，开发者可实现此接口并配置到数据视图中
 * @Author: Paul Chan
 * @Date: 2019-12-20 17:54
 */
public interface DataViewAuthInterceptor {

  /**
   * 自定义拦截接口，开发者可实现此接口实现自己的处理逻辑，
   * 并在数据视图中配置实现类的路径，在数据视图sql执行之前，会调用此接口
   * 代码示例(将当前登录用户名做为筛选条件)：
   * <p>
   *   <code>
   *    @Override
   *   public void intercept(Object context) {
   *     if(!(context instanceof ExecuteContextModel)) {
   *       return;
   *     }
   *     ExecuteContextModel executeContext = (ExecuteContextModel) context;
   *     String sqlAlias = executeContext.getWrapperSqlAlias();
   *     String condition = String.format(" and %s.name = ?", sqlAlias);
   *     UserVo user = SecurityUtils.getCurrentUser();
   *     executeContext.addExecuteSqlParameter(user.getAccount());
   *     executeContext.appendExecuteSql(condition);
   *   }
   *   </code>
   * </p>
   * @param sqlAnalysis
   */
  public void intercept(Object context);

}
