package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.repository.internal.EnvironmentVariableRepositoryCustom;

import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.core.entity.EnvironmentVariableEntity;

/**
 * EnvironmentVariableRepository
 *
 * @description:
 * @author: yanwe
 * @date: 15/May/2019 14:30
 */
@Repository("EnvironmentVariableRepository")
public interface EnvironmentVariableRepository extends JpaRepository<EnvironmentVariableEntity,String>, JpaSpecificationExecutor<EnvironmentVariableEntity>, EnvironmentVariableRepositoryCustom {
  /**
   * 根据键值查询
   * @param key
   * @return
   */
  EnvironmentVariableEntity findByParamKey(String key);
  /**
   * 根据参数名称查询
   * @param code
   * @return
   */
  EnvironmentVariableEntity findByParamCode(String code);
  /**
   * 根据一个或者多个ID信息查询环境变量设定的基本信息和关联信息
   * @param ids
   * @return
   */
  @Query(value="from EnvironmentVariableEntity evn "
      + " where evn.id in (:ids)")
  Set<EnvironmentVariableEntity> findDetailsByIds(@Param("ids") String[] ids);
  /**
   * 按照指定的全局变量的ID信息，查询最终满足这些id编号的数据条目。<br>
   * 这个方法一般用于验证一批给定的id，是否都能在系统中找到对应的数据
   * @param ids 指定的id信息
   * @return 满足的条目数量将会被返回
   */
  @Query(value="select count(id) from engine_env_var where engine_env_var.id in (:ids)" , nativeQuery = true)
  long countByIds(@Param("ids") String[] ids);

  long countByParamCode(String code);

  long countByParamKey(String key);
}