package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.RemoteServiceAddressEntity;
import com.bizunited.platform.core.repository.internal.RemoteServiceAddressRepositoryCustom;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * RemoteServiceAddressRepository
 *
 * @description:
 * @author: yanwe
 * @date: 06/May/2019 10:10
 */
@Repository("RemoteServiceAddressRepository")
public interface RemoteServiceAddressRepository
    extends JpaRepository<RemoteServiceAddressEntity, String>,
        JpaSpecificationExecutor<RemoteServiceAddressEntity>,
        RemoteServiceAddressRepositoryCustom {

  /**
   * 根据编码查询
   *
   * @param code
   * @return
   */
  RemoteServiceAddressEntity findByCode(String code);

  /**
   * 根据别名查询
   *
   * @param alias
   * @return
   */
  RemoteServiceAddressEntity findByAlias(String alias);

  /**
   * 根据状态查询远端服务地址
   * @param status
   * @return
   */
  List<RemoteServiceAddressEntity> findByAddressStatus(Integer status);

  /**
   * 根据id查询远端服务地址数量
   * @param ids
   * @return
   */
  @Query(value="select count(id) from engine_remote_service_address where engine_remote_service_address.id in (:ids)" , nativeQuery = true)
  int countByIds(@Param("ids") String[] ids);

  /**
   * 根据id查询远端服务地址，包含关联信息
   * @param ids
   * @return
   */
  @Query("from RemoteServiceAddressEntity rsa left join fetch rsa.remoteServices rs where rsa.id in (:ids)")
  List<RemoteServiceAddressEntity> findDetailsByIds(@Param("ids") String[] ids);
}
