package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.core.entity.DataSourceEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

import static com.bizunited.platform.common.constant.Constants.PROJECT_NAME;

/**
 * 数据源持久层的自定义实现
 * @Author: Paul Chan
 * @Date: 2020-05-18 11:31
 */
@Repository("DataSourceRepositoryImpl")
public class DataSourceRepositoryImpl implements DataSourceRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;


  @Override
  public Page<DataSourceEntity> findByConditions(DataSourceEntity dataSource, Pageable pageable) {
    if(pageable == null) {
      pageable = PageRequest.of(0, 50);
    }
    StringBuilder hql = new StringBuilder("select ds from DataSourceEntity ds where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from DataSourceEntity ds where 1=1 ");
    Map<String, Object> parameters = new HashMap<>();
    StringBuilder conditions = new StringBuilder();
    if(dataSource != null) {
      if(StringUtils.isNotBlank(dataSource.getCode())) {
        parameters.put("code", dataSource.getCode());
        conditions.append(" and ds.code like concat(concat('%',:code),'%')");
      }
    }
    // 项目名称
    if(StringUtils.isNotBlank(dataSource.getProjectName())) {
      conditions.append(" AND ds.projectName = :projectName ");
      parameters.put(PROJECT_NAME, dataSource.getProjectName());
    }else {
      conditions.append(" AND (ds.projectName = '' OR ds.projectName IS NULL)");
    }
    hql.append(conditions).append(" order by ds.createTime desc");
    countHql.append(conditions);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }
}
