package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * DataViewAuthHorizontalEntity业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_DataViewAuthHorizontalRepository")
public interface DataViewAuthHorizontalRepository
    extends
    JpaRepository<DataViewAuthHorizontalEntity, String>
    , JpaSpecificationExecutor<DataViewAuthHorizontalEntity> {

  /**
   * 按照主键进行详情查询（包括关联信息）已设置的当前数据视图的横向权限
   *
   * @param id 主键
   */
  @Query("select distinct ah from DataViewAuthHorizontalEntity ah " +
      " inner join fetch ah.dataViewAuth aha"
      + " left join fetch ah.authRelations ahr "
      + " where ah.id=:id ")
  public DataViewAuthHorizontalEntity findDetailsById(@Param("id") String id);

  /**
   * 根据数据权限查询横向权限
   *
   * @param dataViewAuth
   * @return
   */
  @Query("select ah from DataViewAuthHorizontalEntity ah where ah.dataViewAuth = :dataViewAuth order by ah.sortIndex asc")
  Set<DataViewAuthHorizontalEntity> findByAuth(@Param("dataViewAuth") DataViewAuthEntity dataViewAuth);

  /**
   * 根据字段名查询
   * @param fieldName
   * @return
   */
  DataViewAuthHorizontalEntity findByFieldName(@Param("fieldName") String fieldName);
}