package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * 数据视图权限拦截器持久化接口定义
 * @Author: Paul Chan
 * @Date: 2019-12-23 10:21
 */
@Repository("DataViewAuthInterceptorRepository")
public interface DataViewAuthInterceptorRepository extends JpaRepository<DataViewAuthInterceptorEntity, String>,
    JpaSpecificationExecutor<DataViewAuthInterceptorEntity> {

  /**
   * 根据权限查询拦截器
   * @param auth
   * @return
   */
  @Query("select i from DataViewAuthInterceptorEntity i where i.dataViewAuth = :auth order by i.sort asc")
  Set<DataViewAuthInterceptorEntity> findByAuth(@Param("auth") DataViewAuthEntity auth);
}
