package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewEntity;
import org.springframework.stereotype.Repository;

@Repository("DataViewRepositoryCustom")
public interface DataViewRepositoryCustom {

  /**
   * 验证主数据库中该表是否存在
   * @param tableName
   * @return
   */
  void checkTable(String tableName);


  /**
   * 检查第三方数据源中某张表是否存在
   * @param dataSourceCode
   * @param tableName
   */
  void checkTable(String dataSourceCode, String tableName);

  /**
   * 使用本本进程的主数据源进行数据视图中设定的最原始SQL的保存。其它操作特性请参见:</br>
   * executeResource(String dataSourceCode , DataViewEntity dataView)方法
   * @param dataView
   * @return
   */
  DataViewEntity executeResource(DataViewEntity dataView);

  /**
   * 使用一个指定的第三方数据源，进行数据视图中设定的最原始SQL的预执行。预执行后，将向调用者返回执行后的SQL输出结构、以及要求填写的系统参数信息</br>
   * 注意，该方法只会对原始SQL进行执行（自动替换原始SQL中的系统参数信息），并不会将预执行后的结构做持久化保存；要进行持久化保存，请使用本服务中的creat方法
   * @param dataSourceCode 指定的第三方数据源
   * @param dataView 这个对象包括了数据视图最原始的SQL设定信息。
   * @return
   */
  DataViewEntity executeResource(String dataSourceCode, DataViewEntity dataView);

}