package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.PageableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

/**
 * 实现mysql的sql分析，在执行sql前，对sql进行分页、参数、权限等处理
 *
 * @Author: Paul Chan
 * @Date: 2019-10-09 16:36
 */
public class MysqlAnalysis extends AbstractSqlAnalysis {


  public MysqlAnalysis(ExecuteContextModel executeContext) {
    super(executeContext);
  }

  /**
   * 分页处理
   */
  protected void pageAnalysis() {
    PageableModel pageable = executeContext.getExecuteParam().getPageable();
    if (pageable == null) {
      return;
    }
    Validate.isTrue(pageable.getPage() >= 0, "分页页码不能小于0");
    Validate.isTrue(pageable.getSize() > 0, "分页大小不能小于1");
    String executeSql = executeContext.getExecuteSql();
    //两部分解析
    //1.先解析count语句
    String countSQL = String.format("select count(*) from (%s) a", executeSql);
    int pageStart = pageable.getPage() * pageable.getSize();
    executeContext.addExecuteCountSqlParameters(executeContext.getExecuteSqlParameters());
    executeContext.addExecuteSqlParameter(pageStart);
    executeContext.addExecuteSqlParameter(pageable.getSize());
    executeContext.appendExecuteSql(" limit ?,?");
    executeContext.setExecuteCountSql(countSQL);
  }

  @Override
  public String concatSql(String... strs) {
    if (strs == null || strs.length == 0) {
      return Constants.EMPTY_CHAR;
    }
    StringBuilder sb = new StringBuilder("concat(");
    sb.append(StringUtils.join(strs, ",")).append(")");
    return sb.toString();
  }

}
