package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.entity.CodeRuleEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * CodeRuleRepositoryCustom
 *
 * @description:
 * @author: yanwe
 * @date: 12/Jun/2019 14:56
 */

@Repository("CodeRuleRepositoryCustom")
public interface CodeRuleRepositoryCustom {

  /**
   *  分页条件查询
   * @param pageable
   * @param conditions
   * @return
   */
  Page<CodeRuleEntity> findByConditions(Pageable pageable, Map<String,Object> conditions);

  /**
   * 按照条件搜索编码生成规则，不支持模糊查询,不分页
   * @param codeRule
   * @return
   */
  List<CodeRuleEntity> findAllByConditions(CodeRuleEntity codeRule);
}
