package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

import static com.bizunited.platform.common.constant.Constants.PROJECT_NAME;

/**
 * @author yinwenjie
 */
@Repository("DynamicTaskSchedulerRepositoryImpl")
public class DynamicTaskSchedulerRepositoryImpl implements DynamicTaskSchedulerRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String TASK_TYPE = "taskType";
  private static final String TASK_CODE = "taskCode";
  private static final String WORKING_STATUS = "workingStatus";
  private static final String T_STATUS = "tstatus";
  private static final String TASK_DESC = "taskDesc";
  private static final String INVOKE_TYPE = "invokeType";
  
  @Override
  public Page<DynamicTaskSchedulerEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    /*
     * -按照任务类型、任务编码、运行状态、任务状态、任务名称进行查询
     * */
    StringBuilder hql = new StringBuilder("from DynamicTaskSchedulerEntity dt where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from DynamicTaskSchedulerEntity dt where 1 = 1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();

    // 任务类型
    Object taskType = conditions.get(TASK_TYPE);
    if(taskType != null) {
      condition.append(" AND dt.taskType = :taskType ");
      parameters.put(TASK_TYPE, taskType);
    }
    // 任务编码
    Object taskCode = conditions.get(TASK_CODE);
    if(taskCode != null) {
      condition.append(" AND dt.taskCode = :taskCode ");
      parameters.put(TASK_CODE, taskCode);
    }
    // 运行状态
    Object workingStatus = conditions.get(WORKING_STATUS);
    if (workingStatus != null) {
      condition.append(" AND dt.workingStatus = :workingStatus ");
      parameters.put(WORKING_STATUS, workingStatus);
    }
    // 任务状态
    Object tstatus = conditions.get(T_STATUS);
    if(tstatus != null) {
      condition.append(" AND dt.tstatus = :tstatus ");
      parameters.put(T_STATUS, tstatus);
    }
    // 任务名称
    Object taskDesc = conditions.get(TASK_DESC);
    if(taskDesc != null) {
      condition.append(" AND dt.taskDesc = :taskDesc ");
      parameters.put(TASK_DESC, taskDesc);
    }
    // 脚本执行类型
    Object invokeType = conditions.get(INVOKE_TYPE);
    if(invokeType != null) {
      condition.append(" AND dt.invokeType = :invokeType ");
      parameters.put(INVOKE_TYPE, invokeType);
    }
    //项目名
    String projectName = (String) conditions.get(PROJECT_NAME);
    if(StringUtils.isNotBlank(projectName)) {
      condition.append(" AND dt.projectName = :projectName ");
      parameters.put(PROJECT_NAME, projectName);
    }else {
      condition.append(" AND (dt.projectName = '' OR dt.projectName IS NULL)");
    }

    hql.append(condition).append(" order by dt.createTime desc  ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }
}