package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.core.entity.log.LoggerFiledMappingEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

/**
 * LoggerFiledMappingEntityRepositoryCustomImpl
 *
 * @description:
 * @author: chengzhongxiang
 * @date: 18/August/2020 15:57
 */
public class LoggerFiledMappingEntityRepositoryCustomImpl implements LoggerFiledMappingEntityRepositoryCustom,
        PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String APPLICATION = "applicationName";
  private static final String FIELDNAME = "fieldName";
  private static final String FIELDDESC = "fieldDesc";

  @Override
  public Page<LoggerFiledMappingEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
      StringBuilder hql = new StringBuilder("from LoggerFiledMappingEntity lfm  where 1 = 1");
      StringBuilder countHql = new StringBuilder("select count(*) from LoggerFiledMappingEntity lfm where 1 = 1");
      StringBuilder condition=new StringBuilder();
      Map<String,Object> parameter=new HashMap<>(5);
      Object applicationName = conditions.get(APPLICATION);
      if(applicationName!=null){
          condition.append(" AND lfm.applicationName like CONCAT('%',:applicationName,'%')");
          parameter.put("applicationName",applicationName);
      }
      Object fieldName = conditions.get(FIELDNAME);
      if(fieldName!=null){
          condition.append(" AND lfm.fieldName like CONCAT('%',:fieldName,'%')");
          parameter.put("fieldName",fieldName);
      }
      Object fieldDesc = conditions.get(FIELDDESC);
      if(fieldDesc!=null){
          condition.append(" AND lfm.fieldDesc like CONCAT('%',:fieldDesc,'%')");
          parameter.put("fieldDesc",fieldDesc);
      }
      hql.append(condition);
      countHql.append(condition);
      return queryByConditions(entityManager,hql.toString(),countHql.toString(),parameter,pageable,false,null);
  }
}
