package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.core.entity.log.LoggerTemplateEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;
/**
 * LoggerTemplateEntityRepositoryCustomImpl
 *
 * @description:
 * @author: chengzhongxiang
 * @date: 18/August/2020 14:52
 */
public class LoggerTemplateEntityRepositoryCustomImpl implements LoggerTemplateEntityRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String CODE = "code";
  private static final String NAME = "name";
  private static final String METHODNAME = "methodName";
  private static final String STATE = "state";
  @Override
  public Page<LoggerTemplateEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
    StringBuilder hql = new StringBuilder("from LoggerTemplateEntity lte  where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from LoggerTemplateEntity lte where 1 = 1");
    StringBuilder condition=new StringBuilder();
    Map<String,Object> parameter=new HashMap<>(5);
    Object name = conditions.get(NAME);
    if(name!=null){
        condition.append(" AND lte.name like CONCAT('%',:name,'%')");
        parameter.put("name",name);
    }
    Object code = conditions.get(CODE);
    if(code!=null){
        condition.append(" AND lte.code like CONCAT('%',:code,'%')");
        parameter.put("code",code);
    }
    Object methodName = conditions.get(METHODNAME);
    if(methodName!=null){
        condition.append(" AND lte.methodName like CONCAT('%',:methodName,'%')");
        parameter.put("methodName",methodName);
    }
    Object state = conditions.get(STATE);
    if(state!=null){
        condition.append(" AND lte.state = :state ");
        parameter.put("state",state);
    }
    hql.append(condition);
    countHql.append(condition);
    return queryByConditions(entityManager,hql.toString(),countHql.toString(),parameter,pageable,false,null);
  }
}
