package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.core.entity.RemoteServiceAddressEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

import static com.bizunited.platform.common.constant.Constants.PROJECT_NAME;

/**
 * RemoteServiceAddressRepositoryImpl
 * @description:
 * @author: yanwe
 * @date: 06/May/2019 10:12
 */
@Repository("RemoteServiceAddressRepositoryImpl")
public class RemoteServiceAddressRepositoryImpl implements RemoteServiceAddressRepositoryCustom, PageRepositoryImpl {

  @Autowired 
  @PersistenceContext 
  private EntityManager entityManager;
  private static final String ALIAS = "alias";
  private static final String CODE = "code";

  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.repository.internal.RemoteServiceAddressRepositoryCustom#findByConditions(org.springframework.data.domain.Pageable, java.util.Map)
   */
  @Override
  public Page<RemoteServiceAddressEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
    StringBuilder hql = new StringBuilder("from RemoteServiceAddressEntity u  where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from RemoteServiceAddressEntity u where 1 = 1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>(4);
    Object code = conditions.get(CODE);
    if (code != null) {
      condition.append(" AND u.code = :code ");
      parameter.put("code", code);
    }
    Object alias = conditions.get(ALIAS);
    if (alias != null) {
      condition.append(" AND u.alias = :alias ");
      parameter.put("alias", alias);
    }
    String projectName = (String) conditions.get(PROJECT_NAME);
    if (StringUtils.isNotBlank(projectName)) {
      condition.append(" AND u.projectName = :projectName ");
      parameter.put(PROJECT_NAME, projectName);
    }else {
      condition.append(" AND (u.projectName = '' OR u.projectName IS NULL)");
    }
    hql.append(condition);
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }
}
