package com.bizunited.platform.core.repository.log;

import com.bizunited.platform.core.entity.log.LoggerInfoEntity;
import com.bizunited.platform.core.repository.internal.LoggerInfoEntityRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * LoggerInfoEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_LoggerInfoEntityRepository")
public interface LoggerInfoEntityRepository
    extends
      JpaRepository<LoggerInfoEntity, String>
      ,JpaSpecificationExecutor<LoggerInfoEntity>
      , LoggerInfoEntityRepositoryCustom
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct loggerInfoEntity from LoggerInfoEntity loggerInfoEntity "
      + " where loggerInfoEntity.id=:id ")
  LoggerInfoEntity findDetailsById(@Param("id") String id);
  /**
   * 按照指定的模块和操作业务编号，查询符合条件的日志信息，并按照日志时间进行倒序排列
   */
  @Query("from LoggerInfoEntity lie where lie.opId = :opid AND lie.module = :module order by lie.opTime DESC")
  Set<LoggerInfoEntity> findByOpidAndModule(@Param("opid") String opid , @Param("module") String module);
}