package com.bizunited.platform.core.service;

import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataSourceTableEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-04-15 11:05
 * @Description: 数据表功能的服务层接口定义
 */
public interface DataSourceTableService {
  /**
   * 分页查询数据表
   * @param pageable
   * @param tableType
   * @param dataSourceId
   * @param status
   * @param tableName
   * @return
   */
  Page<DataSourceTableEntity> findByConditions(Pageable pageable, Integer tableType, String dataSourceId, Integer status, String tableName);
  /**
   * 根据数据源获取数据源的所有表，如果dataSource为null，则从主数据源获取
   * @param dataSource
   * @return
   */
  Set<String> findByDataSource(DataSourceEntity dataSource);
  /**
   * 刷新当前数据源下数据表分类，和数据库中表存在性的真实性对应关系
   */
  void refresh();
  /**
   * 根据ID更新数据表信息
   * @param dataSourceTable
   * @return
   */
  DataSourceTableEntity update(DataSourceTableEntity dataSourceTable);
  /**
   * 更新表说明字断
   * @param dataSource
   * @param tableName
   * @param tableDesc
   */
  void updateTableDesc(DataSourceEntity dataSource, String tableName, String tableDesc);
}
