package com.bizunited.platform.core.service;

import com.bizunited.platform.common.model.MigrateImportModel;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import com.bizunited.platform.core.entity.RemoteServiceAddressEntity;

import java.util.List;

/**
 * RemoteServiceAddressService
 *
 * @description:
 * @author: yanwe
 * @date: 06/May/2019 10:22
 */
@Service
public interface RemoteServiceAddressService {

  /**
   * 分页查询
   * @param code 远端服务地址编码
   * @param alias 远端服务地址别名
   * @param pageable 分页信息
   * @return
   */
  Page<RemoteServiceAddressEntity> findByConditions(String code, String alias, Pageable pageable);


  /**
   * 测试连接
   * @param remoteServiceAddressEntity
   * @param testJson
   */
  void valid(String remoteServiceAddressEntity, String testJson);

  /**
   * 新增
   * @param remoteServiceAddressEntity
   * @param testJson 测试数据
   * @return
   */
  RemoteServiceAddressEntity create(String remoteServiceAddressEntity, String testJson);


  /**
   * 仅仅是实体的新增方法，不做连接验证
   * @param remoteServiceAddressEntity
   * @return
   */
  RemoteServiceAddressEntity create(RemoteServiceAddressEntity remoteServiceAddressEntity);

  /**
   * 修改
   * @param remoteServiceAddressEntity
   * @return
   */
  RemoteServiceAddressEntity update(String remoteServiceAddressEntity, String testJson);


  /**
   * 启用
   * @param addressId 远端服务地址ID
   * @return
   */
  RemoteServiceAddressEntity enable(String addressId);

  /**
   * 禁用
   * @param addressId 远端服务地址ID
   * @return
   */
  RemoteServiceAddressEntity disable(String addressId);


  /**
   * 根据编码查询
   * @param code
   * @return
   */
  RemoteServiceAddressEntity findByCode(String code);

  /**
   * 根据状态查询远端服务地址
   * @param status
   * @return
   */
  List<RemoteServiceAddressEntity> findByAddressStatus(Integer status);

  /**
   * 根据id查询远端服务地址数量
   * @param ids
   * @return
   */
  int countByIds(String[] ids);

  /**
   * 根据id查询远端服务地址，包含关联信息
   * @param ids
   * @return
   */
  List<RemoteServiceAddressEntity> findDetailsByIds(String[] ids);

  /**
   * 导入远端数据源
   * @param importModel
   */
  void importData(MigrateImportModel importModel);
}
