package com.bizunited.platform.core.service;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Map;

/**
 * ScriptService
 *
 * @description:
 * @author: yanwe
 * @date: 27/May/2019 15:49
 */

public interface ScriptService {

  /**
   * 分页查询
   * @param pageable
   * @param name
   * @param language
   * @return
   */
  Page<ScriptEntity> findByConditions(Pageable pageable, String name, String language);

  /**
   * 根据id查询
   * @param scriptId
   * @return
   */
  ScriptEntity findById(String scriptId);

  /**
   * 根据名称查询
   * @param name
   * @return
   */
  ScriptEntity findByName(String name);

  /**
   * 获取脚本内容根据脚本唯一识别名进行查询
   * @param scriptId
   * @return
   */
  String findContentByName(String scriptName);
  
  /**
   * 获取脚本内容
   * @param scriptId
   * @return
   */
  String findContentById(String scriptId);

  /**
   * 更新实体与脚本内容
   * @param scriptEntity
   * @param scriptContent
   * @return
   */
  ScriptEntity update(ScriptEntity scriptEntity, String scriptContent);

  /**
   * 新建
   * @param scriptEntity
   * @param scriptContent
   * @return
   */
  ScriptEntity create(ScriptEntity scriptEntity, String scriptContent);

  /**
   * 执行一个或者多个脚本执行器的调用
   * @param scriptIds 一个或者多个groovy脚本内容的编号信息
   * @return 有调用者直接传递的各种初始化入参信息
   * @throws InvokeProxyException
   */
  Map<String,Object> invoke(String scriptIds[], Map<String, Object> params) throws InvokeProxyException;
  
  /**
   * 直接执行一个groovy脚本片段，如果这个片段存在返回值，则原生返回
   * @param scriptContent 指定的脚本内容
   * @param params 入参，执行完成后，新的全局变量信息也将以该K-V集合为标准进行返回
   * 如果该参数为null，则表示没有外参设定的要求，和出参返回的要求
   * @return
   */
  Object invoke(String scriptContent , Map<String, Object> params);
}
