package com.bizunited.platform.core.service;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.SystemThemeEntity;
import com.bizunited.platform.venus.common.vo.OrdinaryFileVo;
import org.springframework.web.multipart.MultipartFile;

import java.security.Principal;

public interface SystemThemeService {

  /**
   * 上传logo图片并保存主题
   * @param file logo图片文件
   * @param principal 操作人信息
   * @return
   */
  public OrdinaryFileVo uploadLogo(MultipartFile file, Principal principal);

  /**
   * 保存系统主题数据
   * 注：主题数据只能有一条信息，以后的保存都是根据该数据做更新
   * @param theme 主题数据 json格式
   * @param principal 操作人信息
   * @return
   */
  public SystemThemeEntity save(JSONObject theme, Principal principal);

  /**
   * 加载主题数据(注：只有一个主题数据)
   * @return
   */
  public JSONObject findTheme();


  /**
   * 导出主题信息
   * @return
   */
  public byte[] export();

  /**
   * 导入主题信息
   * @param currentUser
   * @param file
   * @return
   */
  public SystemThemeEntity importTheme(Principal currentUser, MultipartFile file);
}
