package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.core.entity.DataSourceEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * DataSourceEntity（第三方数据源）业务模型的服务层接口定义
 * @author saturn
 */
public interface DataSourceService {
  /**
   * 按照主键进行详情查询（不包括关联信息）
   * @param id 主键
   */
  public DataSourceEntity findById(String id);
  /**
   * 查找当前记录的所有第三方数据源信息
   */
  public List<DataSourceEntity> findAll();
  /**
   * 根据数据库编号code（唯一键值），查询第三方数据源信息
   * @param code
   * @return
   */
  public DataSourceEntity findDetailsByCode(String code);

  /**
   * 根绝状态获取数据源
   * @param status
   * @return
   */
  List<DataSourceEntity> findByStatus(Integer status);

  /**
   * 根据编码查询
   * @param code
   * @return
   */
  DataSourceEntity findByCode(String code);

  /**
   * 根据条件分页查询
   * @param dataSource
   * @param pageable
   * @return
   */
  Page<DataSourceEntity> findByConditions(DataSourceEntity dataSource, Pageable pageable);
}