package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;

import java.util.Set;

/**
 * 横向权限选定的权限关系集DataViewAuthVerticalRelationEntity业务模型的服务层接口定义
 *
 * @author saturn
 */
public interface DataViewAuthHorizontalRelationService {

  /**
   * 按照关联的 横向数据权限进行详情查询（包括关联信息）
   *
   * @param authHorizontal 关联的 横向数据权限
   */
  Set<DataViewAuthHorizontalRelationEntity> findDetailsByAuthHorizontal(String authHorizontal);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  DataViewAuthHorizontalRelationEntity findDetailsById(String id);

  /**
   * 按照DataViewAuthHorizontalRelationEntity的主键编号，查询指定的数据信息（不包括任何关联信息）
   *
   * @param id 主键
   */
  DataViewAuthHorizontalRelationEntity findById(String id);

  /**
   * 按照主键进行信息的真删除
   *
   * @param id 主键
   */
  void deleteById(String id);

  /**
   * 按照横向权限实体进行信息的真删除
   *
   * @param authHorizontal
   */
  void deleteByAuthHorizontal(String authHorizontal);

  /**
   * 处理更新、增添、删除权限领域信息
   *
   * @param dataViewAuthHorizontalEntity
   * @param authRelations
   */
  Set<DataViewAuthHorizontalRelationEntity> save(DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity, Set<DataViewAuthHorizontalRelationEntity> authRelations);


}