package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;

import java.util.List;
import java.util.Set;

/**
 * 数据视图权限拦截器服务接口定义
 *
 * @Author: Paul Chan
 * @Date: 2019-12-23 10:23
 */
public interface DataViewAuthInterceptorService {

  /**
   * 保存数据视图权限拦截器
   *
   * @param auth
   * @param interceptors
   * @return
   */
  Set<DataViewAuthInterceptorEntity> save(String authId, Set<DataViewAuthInterceptorEntity> interceptors);

  /**
   * 根据权限ID查询拦截器
   * @param authId
   * @return
   */
  Set<DataViewAuthInterceptorEntity> findByAuthId(String authId);

  /**
   * 根据权限ID删除拦截器
   * @param authId
   */
  void deleteByAuthId(String authId);

  /**
   * 查询数据视图权限拦截器
   * @return
   */
  List<String> findAll();
}
