package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.core.entity.DataViewAuthEntity;

import java.util.List;
import java.util.Set;

/**
 * 数据视图服务的接口定义
 * @Author: Paul Chan
 * @Date: 2020-04-23 11:19
 */
public interface DataViewAuthService {

  /**
   * 创建数据权限s
   * @param dataViewAuth
   * @return
   */
  DataViewAuthEntity create(DataViewAuthEntity dataViewAuth);

  /**
   * 更新数据权限
   * @param dataViewAuth
   * @return
   */
  DataViewAuthEntity update(DataViewAuthEntity dataViewAuth);

  /**
   * 根据ID查询数据权限
   * @param id
   * @return
   */
  DataViewAuthEntity findById(String id);

  /**
   * 根据权限编码获取权限详情
   * @param code
   * @return
   */
  DataViewAuthEntity findDetailsByCode(String code);

  /**
   * 根据数据视图编码获取权限
   * @param dataViewCode
   * @return
   */
  Set<DataViewAuthEntity> findByDataView(String dataViewCode);

  /**
   * 根据数据视图编码和权限编码获取权限
   * @param dataViewCode
   * @param authCode
   * @return
   */
  DataViewAuthEntity findDetailsByDataViewCodeAndCode(String dataViewCode, String authCode);

  /**
   * 根据ID删除
   * @param id
   */
  void deleteById(String id);

  /**
   * 根据数据视图的ID集合查询权限详情
   * @param dataviewIds
   */
  Set<DataViewAuthEntity> findDetailsByDataViewIds(String[] dataviewIds);

  /**
   * 导入数据权限
   * @param auth
   * @return
   */
  void importAuth(DataViewAuthEntity auth, MigrateImportModel importModel);

  /**
   * 批量导入数据权限
   * @param auths
   * @param importModel
   */
  void importAuths(List<DataViewAuthEntity> auths, MigrateImportModel importModel);
}
