package com.bizunited.platform.core.service.dataview.internal;


import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.repository.dataview.DataSourceRepository;
import com.bizunited.platform.core.service.dataview.DataSourceService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * DataSourceEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service("DataSourceEntityServiceImpl")
public class DataSourceServiceImpl implements DataSourceService {
  @Autowired
  private DataSourceRepository dataSourceRepository;
  @Autowired
  private PlatformContext platformContext;

  @Override
  public DataSourceEntity findById(String id) {
    if(StringUtils.isBlank(id)) { 
      return null;
    }
    return this.dataSourceRepository.findById(id).orElse(null);
  }

  @Override
  public DataSourceEntity findDetailsByCode(String code) {
    if(StringUtils.isBlank(code)) { 
      return null;
    }
    return this.dataSourceRepository.findDetailsByCode(code);
  }

  @Override
  public List<DataSourceEntity> findByStatus(Integer status) {
    String projectName = platformContext.getAppName();
    if(StringUtils.isNotBlank(projectName)) {
      return this.dataSourceRepository.findByTstatusAndProjectName(status, projectName);
    }
    return this.dataSourceRepository.findByTstatusAndBlankProjectName(status);
  }

  @Override
  public DataSourceEntity findByCode(String code) {
    return dataSourceRepository.findByCode(code);
  }

  @Override
  public Page<DataSourceEntity> findByConditions(DataSourceEntity dataSource, Pageable pageable) {
    return dataSourceRepository.findByConditions(dataSource, pageable);
  }

  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.service.DataSourceService#findAll()
   */
  @Override
  public List<DataSourceEntity> findAll() {
    String projectName = platformContext.getAppName();
    if(StringUtils.isNotBlank(projectName)) {
      return this.dataSourceRepository.findByProjectName(projectName);
    }
    return this.dataSourceRepository.findByBlankProjectName();
  }

}
