package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.core.common.enums.AuthTypeEnum;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.service.position.PositionService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.service.userGroup.UserGroupService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 权限值服务的接口定义实现
 *
 * @Author: Paul Chan
 * @Date: 2020-04-23 23:28
 */
@Service("DataViewAuthRelationService")
public class DataViewAuthRelationService {

  private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthRelationService.class);

  @Autowired
  private UserService userService;
  @Autowired
  private RoleService roleService;
  @Autowired
  private PositionService positionService;
  @Autowired
  private UserGroupService userGroupService;
  @Autowired
  private OrganizationService organizationService;

  /**
   * 根据权限值和权限类型获取权限对象
   *
   * @param relationId
   * @param authType
   * @return
   */
  public UuidVo findRelation(String relationId, Integer authType) {
    if (StringUtils.isBlank(relationId)) {
      return null;
    }
    if (authType == null) {
      return null;
    }
    UuidVo relation = null;
    AuthTypeEnum authTypeEnum = AuthTypeEnum.valueOfType(authType);
    if(authTypeEnum == null) {
      LOGGER.warn("未知的权限类型:{}", authType);
      return null;
    }
    switch (authTypeEnum) {
      case USER:
        // 用户
        relation = userService.findByAccount(relationId);
        break;
      case ROLE:
        // 角色
        relation = roleService.findByCode(relationId);
        break;
      case POSITION:
        // 岗位
        relation = positionService.findByCode(relationId);
        break;
      case GROUP:
        // 用户组
        relation = userGroupService.findByCode(relationId);
        break;
      case ORG:
        // 组织
        relation = organizationService.findByCode(relationId);
        break;
      default:
        break;
    }
    return relation;
  }

}
