package com.bizunited.platform.core.service.dataview.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Map;

/**
 * 数据视图执行参数接收模型
 * @Author: Paul Chan
 * @Date: 2020-04-16 19:27
 */
@ApiModel("数据视图执行参数接收模型")
public class ExecuteParamModel {

  /**
   * 数据源编码
   */
  private String dataSourceCode;

  /**
   * 数据视图编码
   */
  @ApiModelProperty("数据视图编码")
  private String dataViewCode;

  /**
   * 数据权限的编码
   */
  private String authCode;

  /**
   * 输入的参数
   */
  @ApiModelProperty("输入的参数")
  private Map<String, Object> inputParams;

  /**
   * 关键字段查询参数
   */
  @ApiModelProperty("关键字段查询参数")
  private Map<String, Object> keyParams;

  /**
   * 系统参数
   */
  @ApiModelProperty("系统参数")
  private Map<String, Object> systemParams;

  /**
   * 分页信息
   */
  private PageableModel pageable;

  /**
   * 排序信息
   */
  private SortModel sort;

  public String getDataSourceCode() {
    return dataSourceCode;
  }

  public void setDataSourceCode(String dataSourceCode) {
    this.dataSourceCode = dataSourceCode;
  }

  public String getDataViewCode() {
    return dataViewCode;
  }

  public void setDataViewCode(String dataViewCode) {
    this.dataViewCode = dataViewCode;
  }

  public String getAuthCode() {
    return authCode;
  }

  public void setAuthCode(String authCode) {
    this.authCode = authCode;
  }

  public Map<String, Object> getInputParams() {
    return inputParams;
  }

  public void setInputParams(Map<String, Object> inputParams) {
    this.inputParams = inputParams;
  }

  public Map<String, Object> getKeyParams() {
    return keyParams;
  }

  public void setKeyParams(Map<String, Object> keyParams) {
    this.keyParams = keyParams;
  }

  public Map<String, Object> getSystemParams() {
    return systemParams;
  }

  public void setSystemParams(Map<String, Object> systemParams) {
    this.systemParams = systemParams;
  }

  public PageableModel getPageable() {
    return pageable;
  }

  public void setPageable(PageableModel pageable) {
    this.pageable = pageable;
  }

  public SortModel getSort() {
    return sort;
  }

  public void setSort(SortModel sort) {
    this.sort = sort;
  }

  public Object getSystemParam(String name) {
    if(systemParams != null) {
      return systemParams.get(name);
    }
    return null;
  }

  public Object getInputParam(String name) {
    if(inputParams != null) {
      return inputParams.get(name);
    }
    return null;
  }
}
