package com.bizunited.platform.core.service.invoke;

import org.apache.commons.lang3.Validate;

/**
 * 服务源调用代理器。服务源调用代理器不允许直接通过new完成初始化，只能通过ServicableProxy.build进行初始化。
 * @author yinwenjie
 */
public class InvokeProxy implements HandleChain {
  /**
   * 被代理的真实执行控制器对象
   */
  private HandleChain targetHandleChain;
  /**
   * 本次调用的上下文对象
   */
  private InvokeProxyContext invokeProxyContext = new InvokeProxyContext();
  
  /**
   * 代理调用方法，其中的params参数信息将在正式调用前被事先写入到调用器的上下文中
   * @param params K-V结构中的调用入参
   * @throws InvokeProxyException
   */
  public Object invoke(InvokeParams invokeParams) throws InvokeProxyException {
    Validate.notNull(this.targetHandleChain , "错误的代理目标，请检查!!");
    
    // 构建初始化参数
    // TODO 进行入参的验证，各入参部分可以没有值，但是不能为null
    this.invokeProxyContext.setParams(invokeParams);
    this.targetHandleChain.doHandle(this.invokeProxyContext, HandleChain.ChainLogic.CONTINUE);
    
    // 调用成功后取得返回值
    return this.invokeProxyContext.getResult();
  }
  
  @Override
  public void doHandle(InvokeProxyContext context, ChainLogic chainLogic) throws InvokeProxyException {
    throw new IllegalArgumentException("不允许在服务过程代理器中直接调用doHandle(invokeProxyContext, ChainLogic)方法;");
  }

  void setTargetHandleChain(HandleChain targetHandleChain) {
    this.targetHandleChain = targetHandleChain;
  }
}