package com.bizunited.platform.core.service.invoke;

/**
 * 服务源调用链中的请求过程处理接口
 * @author yinwenjie
 */
public interface InvokeRequestHandle {  
  /**
   * 请求链上需要实现的逻辑代码，分别写在同步的方法中。当InvokeRequest处理链上的当前处理节点被调用时，该方法被激活
   * @param context 当前服务调用处理过程的上下文
   * @param chain 调用过程的控制器
   * @throws InvokeProxyException 一旦抛出异常，整个服务调用过程将被终止，异常信息将会直接返回给最终调用客户端。
   */
  public void doHandle(InvokeProxyContext context , HandleChain chain) throws InvokeProxyException;
}