package com.bizunited.platform.core.service.log;

import com.bizunited.platform.core.entity.log.LoggerFiledMappingEntity;
import com.bizunited.platform.core.repository.log.LoggerFiledMappingEntityRepository;
import com.bizunited.platform.core.service.LoggerFiledMappingEntityService;

import com.bizunited.platform.rbac.server.util.SecurityUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * LoggerFiledMappingEntity业务模型的服务层接口实现
 * @author saturn
 */
@Service
public class LoggerFiledMappingEntityServiceImpl implements LoggerFiledMappingEntityService {
  @Autowired
  private LoggerFiledMappingEntityRepository loggerFiledMappingEntityRepository;

  @Transactional
  @Override
  public LoggerFiledMappingEntity create(LoggerFiledMappingEntity loggerFiledMappingEntity) {
    LoggerFiledMappingEntity current = this.createForm(loggerFiledMappingEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public LoggerFiledMappingEntity createForm(LoggerFiledMappingEntity loggerFiledMappingEntity) {
   /* 
    * 针对1.1.3版本的需求，这个对静态模型的保存操作做出调整，新的包裹过程为：
    * 1、如果当前模型对象不是主模型
    * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
    * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
    * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理
    * 2、如果当前模型对象是主业务模型
    *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
    *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
    *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
    * 2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
    *   2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
    *   2.3.2、以及验证每个分组的OneToMany明细信息
    * */
    //设置创建时间与账号，更新时间与账号
    Date date = new Date();
    String userAccount = SecurityUtils.getUserAccount();
    loggerFiledMappingEntity.setCreateTime(date);
    loggerFiledMappingEntity.setCreateAccount(userAccount);
    loggerFiledMappingEntity.setModifyAccount(userAccount);
    loggerFiledMappingEntity.setModifyTime(date);
    this.createValidation(loggerFiledMappingEntity);
    
    // ===============================
    //  和业务有关的验证填写在这个区域    
    // ===============================
    
    this.loggerFiledMappingEntityRepository.saveAndFlush(loggerFiledMappingEntity);
    
    // 返回最终处理的结果，里面带有详细的关联信息
    return loggerFiledMappingEntity;
  }
  /**
   * 在创建一个新的LoggerFiledMappingEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  private void createValidation(LoggerFiledMappingEntity loggerFiledMappingEntity) {
    Validate.notNull(loggerFiledMappingEntity , "进行当前操作时，信息对象必须传入!!");
    // 判定那些不能为null的输入值：条件为 caninsert = true，且nullable = false
    Validate.isTrue(StringUtils.isBlank(loggerFiledMappingEntity.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    loggerFiledMappingEntity.setId(null);
    Validate.notNull(loggerFiledMappingEntity.getCreateTime(), "添加信息时，创建时间不能为空！");
    Validate.notBlank(loggerFiledMappingEntity.getApplicationName(), "添加信息时，应用名称不能为空！");
    Validate.notBlank(loggerFiledMappingEntity.getLanguage(), "添加信息时，语言，默认CH不能为空！");
    Validate.notBlank(loggerFiledMappingEntity.getFieldName(), "添加信息时，字段名不能为空！");
    Validate.notNull(loggerFiledMappingEntity.getMappingType(), "添加信息时，映射方式 0--文本，1--字典表不能为空！");
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况）
    Validate.isTrue(loggerFiledMappingEntity.getApplicationName() == null || loggerFiledMappingEntity.getApplicationName().length() < 255 , "应用名称,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(loggerFiledMappingEntity.getLanguage() == null || loggerFiledMappingEntity.getLanguage().length() < 64 , "语言，默认CH,在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(loggerFiledMappingEntity.getFieldName() == null || loggerFiledMappingEntity.getFieldName().length() < 64 , "字段名, 在进行添加时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(loggerFiledMappingEntity.getFieldDesc() == null || loggerFiledMappingEntity.getFieldDesc().length() < 255 , "字段描述,在进行添加时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(loggerFiledMappingEntity.getDictCode() == null || loggerFiledMappingEntity.getDictCode().length() < 255 , "字典表code,在进行添加时填入值超过了限定长度(255)，请检查!");
    //验证应用名、英文字段名不重复
    LoggerFiledMappingEntity fieldEntity = this.loggerFiledMappingEntityRepository.findByFieldName(loggerFiledMappingEntity.getFieldName());
    Validate.isTrue(fieldEntity==null,"添加信息时，英文字段名不能重复");
    LoggerFiledMappingEntity applicationEntity = this.loggerFiledMappingEntityRepository.findByApplicationName(loggerFiledMappingEntity.getApplicationName());
    Validate.isTrue(applicationEntity==null,"添加信息时，应用名称不能重复");
  }
  @Transactional
  @Override
  public LoggerFiledMappingEntity update(LoggerFiledMappingEntity loggerFiledMappingEntity) {
    LoggerFiledMappingEntity current = this.updateForm(loggerFiledMappingEntity);
    //==================================================== 
    //    这里可以处理第三方系统调用（或特殊处理过程）
    //====================================================
    return current;
  } 
  @Transactional
  @Override
  public LoggerFiledMappingEntity updateForm(LoggerFiledMappingEntity loggerFiledMappingEntity) {
    /* 
     * 针对1.1.3版本的需求，这个对静态模型的修改操作做出调整，新的过程为：
     * 1、如果当前模型对象不是主模型
     * 1.1、那么创建前只会验证基本信息，直接的ManyToOne关联（单选）和ManyToMany关联（多选）
     * 1.2、验证完成后，也只会保存当前对象的基本信息，直接的单选
     * TODO 1.3、ManyToMany的关联（多选），暂时需要开发人员自行处理（求删除、新增绑定的代码已生成）
     * 
     * 2、如果当前模型对象是主业务模型
     *  2.1、创建前会验证当前模型的基本属性，单选和多选属性
     *  2.2、然后还会验证当前模型关联的各个OneToMany明细信息，调用明细对象的服务，明每一条既有明细进行验证
     *  （2.2的步骤还需要注意，如果当前被验证的关联对象是回溯对象，则不需要验证了）
     *  2.3、还会验证当前模型关联的各个OneToOne分组，调用分组对象的服务，对分组中的信息进行验证
     *    2.3.1、包括验证每一个分组项的基本信息、直接的单选、多选信息
     *    2.3.2、以及验证每个分组的OneToMany明细信息
     * */
    
    this.updateValidation(loggerFiledMappingEntity);
    // ===================基本信息
    String currentId = loggerFiledMappingEntity.getId();
    Optional<LoggerFiledMappingEntity> op_currentLoggerFiledMappingEntity = this.loggerFiledMappingEntityRepository.findById(currentId);
    LoggerFiledMappingEntity currentLoggerFiledMappingEntity = op_currentLoggerFiledMappingEntity.orElse(null);
    currentLoggerFiledMappingEntity = Validate.notNull(currentLoggerFiledMappingEntity ,"未发现指定的原始模型对象信");
    //更新更新时间与账号
    currentLoggerFiledMappingEntity.setModifyAccount(SecurityUtils.getUserAccount());
    currentLoggerFiledMappingEntity.setModifyTime(new Date());
    // 开始重新赋值——一般属性
    currentLoggerFiledMappingEntity.setApplicationName(loggerFiledMappingEntity.getApplicationName());
    currentLoggerFiledMappingEntity.setLanguage(loggerFiledMappingEntity.getLanguage());
    currentLoggerFiledMappingEntity.setFieldName(loggerFiledMappingEntity.getFieldName());
    currentLoggerFiledMappingEntity.setMappingType(loggerFiledMappingEntity.getMappingType());
    currentLoggerFiledMappingEntity.setFieldDesc(loggerFiledMappingEntity.getFieldDesc());
    currentLoggerFiledMappingEntity.setDictCode(loggerFiledMappingEntity.getDictCode());
    this.loggerFiledMappingEntityRepository.saveAndFlush(currentLoggerFiledMappingEntity);
    return currentLoggerFiledMappingEntity;
  }
  /**
   * 在更新一个已有的LoggerFiledMappingEntity模型对象之前，该私有方法检查对象各属性的正确性，其id属性必须有值
   */
  private void updateValidation(LoggerFiledMappingEntity loggerFiledMappingEntity) {
    Validate.isTrue(!StringUtils.isBlank(loggerFiledMappingEntity.getId()), "修改信息时，当期信息的数据编号（主键）必须有值！");
    
    // 基础信息判断，基本属性，需要满足not null
    Validate.notBlank(loggerFiledMappingEntity.getApplicationName(), "修改信息时，应用名称不能为空！");
    Validate.notBlank(loggerFiledMappingEntity.getLanguage(), "修改信息时，语言，默认CH不能为空！");
    Validate.notBlank(loggerFiledMappingEntity.getFieldName(), "修改信息时，语言，默认CH不能为空！");
    Validate.notNull(loggerFiledMappingEntity.getMappingType(), "修改信息时，映射方式 0--文本，1--字典表不能为空！");
    Validate.isTrue(loggerFiledMappingEntity.getApplicationName() == null || loggerFiledMappingEntity.getApplicationName().length() < 255 , "应用名称,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(loggerFiledMappingEntity.getLanguage() == null || loggerFiledMappingEntity.getLanguage().length() < 64 , "语言，默认CH,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(loggerFiledMappingEntity.getFieldName() == null || loggerFiledMappingEntity.getFieldName().length() < 64 , "语言，默认CH,在进行修改时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(loggerFiledMappingEntity.getFieldDesc() == null || loggerFiledMappingEntity.getFieldDesc().length() < 255 , "字段描述,在进行修改时填入值超过了限定长度(255)，请检查!");
    Validate.isTrue(loggerFiledMappingEntity.getDictCode() == null || loggerFiledMappingEntity.getDictCode().length() < 255 , "字典表code,在进行修改时填入值超过了限定长度(255)，请检查!");
    //验证应用名、英文字段名不重复
    LoggerFiledMappingEntity currentEntity = this.loggerFiledMappingEntityRepository.findById(loggerFiledMappingEntity.getId()).orElse(null);
    if(!StringUtils.equals(currentEntity.getFieldName(),loggerFiledMappingEntity.getFieldName())){
      LoggerFiledMappingEntity fieldEntity = this.loggerFiledMappingEntityRepository.findByFieldName(loggerFiledMappingEntity.getFieldName());
      Validate.isTrue(fieldEntity==null,"添加信息时，英文字段名不能重复");
    }
    if(!StringUtils.equals(currentEntity.getApplicationName(),loggerFiledMappingEntity.getApplicationName())){
      LoggerFiledMappingEntity applicationEntity = this.loggerFiledMappingEntityRepository.findByApplicationName(loggerFiledMappingEntity.getApplicationName());
      Validate.isTrue(applicationEntity==null,"添加信息时，应用名称不能重复");
    }
  } 
  @Override
  public LoggerFiledMappingEntity findDetailsById(String id) {
    /* 
     * 1、首先查询这个主业务模型的基本信息和关联的（ManyToOne）单选信息和（ManyToMany）多选信息 
     * 2、然后查询这个主业务模型的明细关联信息（OneToMany关联），如下：
     *   2.1、每一个明细关联信息都需要按照当前主业务表的id，查询其下的一般信息、单选信息和多选信息
     *   2.2、查询到的信息将返回给主业务模型的相关字段进行关联
     * 3、查询这个主业务模型的分组关联信息（OneToOne关联），如下：
     *   3.1、每一分组信息都要查询分组的一般信息，以及分组的单选和多选关联信息
     *   3.2、然后查询分组信息下可能的明细信息（实际上就是以上”步骤2“的操作步骤的重用）
     *   3.3、最后将得到的分组信息，和主业务表的相关字段进行关联
     * 注意：不能偷懒只写一个HQL，因为关联信息很多，数据表一旦过大，会有10多个左外连接，而且经常出现重复数据
     * */
    
    // 这是主模型下的明细查询过程
    // 1、=======
    if(StringUtils.isBlank(id)) {
      return null; 
    } 
    Optional<LoggerFiledMappingEntity> current = this.loggerFiledMappingEntityRepository.findById(id);
    if(!current.isPresent()) {
      return null;
    } 
    return current.get();
  }
  @Override
  public LoggerFiledMappingEntity findById(String id) {
    if(StringUtils.isBlank(id)) {
      return null;
    }
    
    Optional<LoggerFiledMappingEntity> op = loggerFiledMappingEntityRepository.findById(id);
    return op.orElse(null); 
  }
  @Override
  @Transactional
  public void deleteById(String id) {
    // 只有存在才进行删除
    Validate.notBlank(id , "进行删除时，必须给定主键信息!!");
    LoggerFiledMappingEntity current = this.findById(id);
    if(current != null) { 
      this.loggerFiledMappingEntityRepository.delete(current);
    }
  }

  /**
   * 根据表单(应用名称、字段名、字段描述)动态分页查询
   *
   * @param lf
   * @param pageable
   * @return
   */
  @Override
  public Page<LoggerFiledMappingEntity> findByConditions(LoggerFiledMappingEntity lf, Pageable pageable) {
    Validate.notNull(pageable, "查询分页信息不能为空!");
    Map<String,Object> conditions=new HashMap<>(5);
    String applicationName=lf.getApplicationName();
    if(StringUtils.isNotBlank(applicationName)){
      conditions.put("applicationName",applicationName);
    }
    String fieldName=lf.getFieldName();
    if(StringUtils.isNotBlank(fieldName)){
      conditions.put("fieldName",fieldName);
    }
    String fieldDesc=lf.getFieldDesc();
    if(StringUtils.isNotBlank(fieldDesc)){
      conditions.put("fieldDesc",fieldDesc);
    }
    return this.loggerFiledMappingEntityRepository.findByConditions(pageable,conditions);
  }


} 
