package com.bizunited.platform.core.service.script.persistent;

import java.time.Duration;

import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.ExpiryPolicy;
import org.springframework.stereotype.Component;

/**
 * SimplePersistentGroovyServiceFactory
 * 脚本于内存中的存储/读取获取方法工厂
 * @description:
 * @author: yanwe
 * @date: 23/May/2019 09:57
 */
@Component
public class SimplePersistentGroovyServiceFactory extends PersistentGroovyServiceFactory {

  private static Cache<String, Object> cache = null;

  public SimplePersistentGroovyServiceFactory() {
    if(cache == null) {
      synchronized (SimplePersistentGroovyServiceFactory.class) {
        while (cache == null) {
          // 设置集合最大数据量
          ResourcePools resourcePools = ResourcePoolsBuilder.heap(500).build();
          // 设置过期策略为：失效前允许存活5秒
          ExpiryPolicy<Object, Object> expiryPolicy = ExpiryPolicyBuilder.timeToLiveExpiration(Duration.ofSeconds(60l));
          CacheConfigurationBuilder<String, Object> cacheConfigurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, resourcePools);
          CacheConfiguration<String, Object> cacheConfiguration = cacheConfigurationBuilder.withExpiry(expiryPolicy).build();
          
          // 开始构建缓存
          CacheManagerBuilder<CacheManager> build = CacheManagerBuilder.newCacheManagerBuilder();
          CacheManager cacheManager =
              build.withCache("preConfigured",cacheConfiguration)
                  .withDefaultSizeOfMaxObjectSize(1024L, MemoryUnit.MB)
                  .build(true);
          cache = cacheManager.getCache("preConfigured", String.class, Object.class);
        }
      }
    }
  }

  @Override
  public PeristentGroovyClassService createPeristentGroovyClassService() {
    return new SimplePersistentGroovyClassService(cache);
  }
}

