package com.bizunited.platform.core.service.serviceable.handle;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;

/**
 * 基于调用链工作的服务源调用器
 * @author yinwenjie
 */
@Component("ServiceMethodExecutionHandle")
public class ServiceMethodExecutionHandle implements InvokeRequestHandle {
  @Autowired
  private ServicableMethodService servicableMethodService;
  
  public static final String SERVER_NAME_PARAM = "_service_name_";
  
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    InvokeParams  invokeParams = context.getParams();
    Object[] args = invokeParams.getVariables();
    String serviceName = invokeParams.getInvokeParam(SERVER_NAME_PARAM).toString();
    
    // 调用并记录返回值
    Object result = this.servicableMethodService.invoke(serviceName, args);
    context.setResult(result);
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
}
