package com.bizunited.platform.core.service.serviceable.model;

import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.util.List;

/**
 * nebula服务方法详细描述
 * @author yinwenjie
 * @since V2.2+
 */
@ApiModel(value = "ServicableMethodEntity" , description="nebula服务方法详细描述")
public class ServicableMethodInfo {
  /**
   * 基于后端代码，服务层的服务源名。这个属性是服务源在系统中的唯一标示。例如UserTestService.createTest
   */
  @ApiModelProperty(name="name" , value="基于后端代码，服务层的服务源名。这个属性是服务源在系统中的唯一标示。例如UserTestService.createTest")
  private String name = "";
  /**
   * 指示当前服务的中文描述
   */
  @ApiModelProperty(name="desc" , value="指示当前服务的中文描述")
  private String description = "";
  /**
   * 如果存在返回信息，且返回信息是一个业务对象，则可以使用该属性指定这个业务对象的哪些直接或间接属性不需要进行返回
   */
  @ApiModelProperty(name="returnPropertiesFilter" , value="如果存在返回信息，且返回信息是一个业务对象，则可以使用该属性指定这个业务对象的哪些直接或间接属性不需要进行返回"
      , notes="例如:\"name,myoder,record.name\"。表示这个返回对象中的两个直接属性name、myoder不需要返回，另外返回对象中有一个间接关联的对象record下的name属性也不需要返回")
  private String returnPropertiesFilter;
  /**
   * 简单的方法名，只包括方法名本身，不包括包名、接口类名
   * 主要方便进行前端接口调用后的显示，因为method对象本身不被json化
   */
  @ApiModelProperty(name="simpleMethodName" , value="简单的方法名，只包括方法名本身，不包括包名、接口类名")
  private String simpleMethodName;
  /**
   * 完整的接口名，包括包名和类名
   */
  @ApiModelProperty(name="interfaceName" , value="完整的接口名，包括包名和类名")
  private String interfaceName;
  /**
   * 返回信息是否为一个集合
   */
  @ApiModelProperty(name="returnCollection" , value="返回信息是否为一个集合")
  private boolean returnCollection;
  /**
   * 返回参数的对象类型，（没有返回类型的，存java.lang.Void）
   */
  @ApiModelProperty(name="returnClassName" , value="返回参数的对象类型，（没有返回类型的，存java.lang.Void)")
  private Class<?> returnClass;
  /**
   * 该方法对应的参数信息（如果当前方法没有参数信息，则返回null）
   */
  @ApiModelProperty(name="properties" , value="该方法对应的参数信息")
  private List<ServicableMethodProperty> properties;
  /**
   * 该方法的应用范围
   */
  @ApiModelProperty(name="usedScope" , value="该方法的应用范围")
  private NebulaServiceMethod.ScopeType usedScope;
  /**
   * 如果在进行原始方法调用前，需要进行request handle的调用</br>
   * 这里可以填写request handle的类信息，那么服务源调用时，代理器会自动加载这些handle
   */
  private Class<?>[] requestHandleTypes;
  /**
   * 如果在进行原始方法调用后，需要进行response handle的调用</br>
   * 这里可以填写request handle的类信息，那么服务源调用时，代理器会自动加载这些handle
   */
  private Class<?>[] responseHandleTypes;
  /**
   * 如果在进行原始方法调用前，需要调用一组预制好的request handle，则可以设定该值。
   * 这个字符串代表一个spring bean，其返回类型为InvokeProxyBuilder，它代表了一组已定义好的request handle。</br>
   * TODO 目前nebula业务构建平台中，已经预制好的各组request handle如下所示：</br>
   */
  @ApiModelProperty(name="requestHandleGroup" , value="如果在进行原始方法调用前，需要调用一组预制好的response handle，则可以设定该值。")
  private String requestHandleGroup;
  /**
   * 如果在进行原始方法调用后，需要调用一组预制好的response handle，则可以设定该值。
   * 这个字符串代表一个spring bean，其返回类型为InvokeProxyBuilder，它代表了一组已定义好的response handle。</br>
   * TODO 目前nebula业务构建平台中，已经预制好的各组response handle如下所示：</br>
   */
  @ApiModelProperty(name="responseHandleGroup" , value="如果在进行原始方法调用前，需要调用一组预制好的response handle，则可以设定该值。")
  private String responseHandleGroup;

  /**
   * 项目名
   */
  @ApiModelProperty("项目名")
  @SaturnColumn(description = "项目名")
  @Column(name = "project_name", length = 128, columnDefinition = "varchar(128) default '' COMMENT '项目名'")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }
  public String getReturnPropertiesFilter() {
    return returnPropertiesFilter;
  }
  public void setReturnPropertiesFilter(String returnPropertiesFilter) {
    this.returnPropertiesFilter = returnPropertiesFilter;
  }
  public String getSimpleMethodName() {
    return simpleMethodName;
  }
  public void setSimpleMethodName(String simpleMethodName) {
    this.simpleMethodName = simpleMethodName;
  }
  public String getInterfaceName() {
    return interfaceName;
  }
  public void setInterfaceName(String interfaceName) {
    this.interfaceName = interfaceName;
  }
  public boolean isReturnCollection() {
    return returnCollection;
  }
  public void setReturnCollection(boolean returnCollection) {
    this.returnCollection = returnCollection;
  }
  public Class<?> getReturnClass() {
    return returnClass;
  }
  public void setReturnClass(Class<?> returnClass) {
    this.returnClass = returnClass;
  }
  public List<ServicableMethodProperty> getProperties() {
    return properties;
  }
  public void setProperties(List<ServicableMethodProperty> properties) {
    this.properties = properties;
  }
  public NebulaServiceMethod.ScopeType getUsedScope() {
    return usedScope;
  }
  public void setUsedScope(NebulaServiceMethod.ScopeType usedScope) {
    this.usedScope = usedScope;
  }
  public Class<?>[] getRequestHandleTypes() {
    return requestHandleTypes;
  }
  public void setRequestHandleTypes(Class<?>[] requestHandleTypes) {
    this.requestHandleTypes = requestHandleTypes;
  }
  public Class<?>[] getResponseHandleTypes() {
    return responseHandleTypes;
  }
  public void setResponseHandleTypes(Class<?>[] responseHandleTypes) {
    this.responseHandleTypes = responseHandleTypes;
  }
  public String getRequestHandleGroup() {
    return requestHandleGroup;
  }
  public void setRequestHandleGroup(String requestHandleGroup) {
    this.requestHandleGroup = requestHandleGroup;
  }
  public String getResponseHandleGroup() {
    return responseHandleGroup;
  }
  public void setResponseHandleGroup(String responseHandleGroup) {
    this.responseHandleGroup = responseHandleGroup;
  }
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((name == null) ? 0 : name.hashCode());
    return result;
  }
  /**
   * 只要name属性相同，就认为是同一个ServicableMethodInfo
   */
  @Override
  public boolean equals(Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (getClass() != obj.getClass()) return false;
    ServicableMethodInfo other = (ServicableMethodInfo) obj;
    if (name == null) {
      if (other.name != null) return false;
    } else if (!name.equals(other.name)) return false;
    return true;
  }
  
}