package com.bizunited.platform.core.service.serviceable.template;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;

/**
 * 处理调用时传来的data-json结构
 * @author yinwenjie
 */
@Component
public class JsonDataValueMappingTemplate implements ValueMappingTemplate {

  @Override
  public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
    /*
     * 满足当前模板的具体处理条件是：
     * 1、下层实际入参没有ServiceMethodParam注解
     * 2、被支持的目标类型只能是JSON类型
     * 3、不能是数组
     * */
    
    // 1、========
    ServiceMethodParam serviceMethodParam = parameter.getAnnotation(ServiceMethodParam.class);
    if(serviceMethodParam != null) {
      return false;
    }
    Class<?> parameterType = parameter.getType();
    // 被支持的目标类型只能是JSON类型
    if(!JSON.class.isAssignableFrom(parameterType)) {
      return false;
    }
    
    // 3、========
    boolean isArray = parameterType.isArray();
    Validate.isTrue(!isArray , "end-point连接点调用时，要进行data-json转换的参数不能使用数组类型进行描述；如果并不是json对象转换而是java对象类型转换，请增加ServiceMethodParam注解!!");
    return true;
  }

  @Override
  public Object mapping(Class<?> targetClass, Method targetMethod, Parameter parameter, int index, String parameterName , InvokeParams invokeParams) {
    // 直接返回invokeParams中关于json data的信息即可
    Object values = invokeParams.getJsonData();
    return values;
  }
}
