package com.bizunited.platform.core.service.serviceable.template;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.service.invoke.InvokeParams;

/**
 * 处理String类型的类转换和值映射
 * @author yinwenjie
 */
@Component
public class StringValueMappingTemplate implements ValueMappingTemplate {

  @Override
  public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
    Class<?> parameterType = parameter.getType();
    boolean isArray = parameterType.isArray();
    
    // 写成两个if条件，主要实在逻辑上好进行管理和区分
    // 如果end-point入参不是数组，且当前入参类型为String类型，则该值映射模板支持映射体系
    if(!isArray && parameterType == String.class) {
      Validate.isTrue(this.checkServiceMethodParamAnnotation(parameter) , "设定服务源时String类型的参数[%s]，必须携带ServiceMethodParam注解" , targetMethod.toString());
      return true;
    }
    // 如果join-point入参是数组，且当前入参原始类型为String类型，则该值映射模板支持映射体系
    if(isArray && parameterType.getComponentType() == String.class) {
      Validate.isTrue(this.checkServiceMethodParamAnnotation(parameter) , "设定服务源时String类型的参数[%s]，必须携带ServiceMethodParam注解" , targetMethod.toString());
      return true;
    }
    
    return false;
  }

  @Override
  public Object mapping(Class<?> targetComponentType, Method targetMethod, Parameter parameter, int index , String parameterName , InvokeParams invokeParams) {
    Class<?> parameterType = parameter.getType();
    boolean isTypeArray = parameterType.isArray();
    if(StringUtils.isBlank(parameterName)) {
      return null;
    }
    Object values = invokeParams.getInvokeParam(parameterName);
    if(values == null) {
      return null;
    }
    boolean isValueArray = values.getClass().isArray();
    
    /*
     * 值映射方式根据参数类型和值类型的不同来看，一共有四种工作场景
     * */
    if(!isTypeArray && !isValueArray) {
      return values.toString();
    } else if(!isTypeArray && isValueArray){
      throw new IllegalArgumentException(String.format("index[%d]索引位发现数组值，请检查!!", index));
    } else if(isTypeArray && !isValueArray) {
      throw new IllegalArgumentException(String.format("index[%d]索引位未发现数组定义，请检查传值!!", index));
    } else {
      return Arrays.asList(values).toArray(new String[] {});
    }
  }
}
