package com.bizunited.platform.core.service.serviceable.template.base;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

import org.apache.commons.lang3.StringUtils;

import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.serviceable.template.ValueMappingTemplate;

/**
 * 该抽象的值映射模板，负责在进行end-point值映射时，协助进行八大基础类型的映射处理
 * @author yinwenjie
 */
public abstract class AbstractPrimitiveValueMappingTemplate implements ValueMappingTemplate {
  
  @Override
  public Object mapping(Class<?> targetClass, Method targetMethod, Parameter parameter, int index, String parameterName, InvokeParams invokeParams) {
    Class<?> parameterType = parameter.getType();
    boolean isTypeArray = parameterType.isArray();
    if(StringUtils.isBlank(parameterName)) {
      return null;
    }
    Object values = invokeParams.getInvokeParam(parameterName);
    if(values == null) {
      return null;
    }
    boolean isValueArray = values.getClass().isArray();
    
    
    // 如果当前参数类型和传入值
    if(!isTypeArray && !isValueArray) {
      return this.mappingNoArrayToNoArray(targetClass, targetMethod, parameter, index, parameterName, invokeParams, values);
    } else if(isTypeArray && !isValueArray) {
      throw new IllegalArgumentException(String.format("index[%d]索引位发现数组值，请检查!!", index));
    } else if(!isTypeArray && isValueArray) {
      throw new IllegalArgumentException(String.format("index[%d]索引位未发现数组类型定义，请检查!!", index));
    } 
    // 这种情况下，参数定义类型不可能是小写的基础类型，因为之前已完成判定
    else if(isTypeArray && isValueArray) {
      return this.mappingArrayToArray(targetClass, targetMethod, parameter, index, parameterName, invokeParams, values);
    }
    
    // 不可能指定到这个位置
    return null;
  }
  
  /**
   * 该实现方法，负责处理参数定义不是数组，值传入也不是数组的情况
   * @return
   */
  protected abstract Object mappingNoArrayToNoArray(Class<?> targetClass, Method targetMethod, Parameter parameter, int index, String parameterName, InvokeParams invokeParams , Object value);
  
  /**
   * 该实现方法，负责处理参数定义是数组，值传入也是数组的情况
   * @return
   */
  protected abstract Object mappingArrayToArray(Class<?> targetClass, Method targetMethod, Parameter parameter, int index, String parameterName, InvokeParams invokeParams , Object value);
}
