package com.bizunited.platform.core.service.serviceable.template.snative;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

import org.springframework.stereotype.Component;

import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.serviceable.template.ValueMappingTemplate;

/**
 * 上下文参数对象的映射
 * @author yinwenjie
 */
@Component
public class InvokeParamsValueMappingTemplate implements ValueMappingTemplate {

  @Override
  public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
    Class<?> parameterType = parameter.getType();
    boolean isArray = parameterType.isArray();
    
    // 不能有参数注解
    ServiceMethodParam serviceMethodParam = parameter.getAnnotation(ServiceMethodParam.class);
    if(serviceMethodParam != null) {
      return false;
    }
    // 不能是数组
    if(isArray) {
      return false;
    }
    // 参数类型必须是InvokeParams
    if(parameterType == InvokeParams.class) {
      return true;
    }
    
    return false;
  }

  @Override
  public Object mapping(Class<?> targetClass, Method targetMethod, Parameter parameterType, int index, String parameterName, InvokeParams invokeParams) {
    return invokeParams;
  }
}