package com.bizunited.platform.core.vo.dataview;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Map;

/**
 * 数据视图字段VO
 * @Author: Paul Chan
 * @Date: 2019-11-06 14:33
 */
@ApiModel("数据视图导出excel字段")
public class DataviewExportExcelFieldVo {

  @NotBlank(message = "字段名称不能为空！！")
  @ApiModelProperty("字段名称")
  private String fieldName;

  @NotNull(message = "排序不能为空")
  @ApiModelProperty("排序")
  private Integer sortIndex;

  @NotBlank(message = "显示名称不能为空！！")
  @ApiModelProperty("显示名称")
  private String displayName;

  @ApiModelProperty("字段类型")
  private String fieldType;

  @ApiModelProperty("格式")
  private String format;

  @ApiModelProperty("数据字典")
  private Map<String, String> dicts;

  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public String getFieldType() {
    return fieldType;
  }

  public void setFieldType(String fieldType) {
    this.fieldType = fieldType;
  }

  public String getFormat() {
    return format;
  }

  public void setFormat(String format) {
    this.format = format;
  }

  public Map<String, String> getDicts() {
    return dicts;
  }

  public void setDicts(Map<String, String> dicts) {
    this.dicts = dicts;
  }
}
