/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.common.constant;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnBusinessTableConst {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnBusinessTableConst.class);
    private static final Set<String> UN_BUSINESS_TABLE = new HashSet<String>();

    private UnBusinessTableConst() {
    }

    public static boolean isUnBusinessTable(String tableName) {
        return UN_BUSINESS_TABLE.contains(tableName);
    }

    static {
        try (InputStream is = UnBusinessTableConst.class.getClassLoader().getResourceAsStream("unbusiness-table.json");
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));){
            StringBuilder sb = new StringBuilder();
            String line = bufferedReader.readLine();
            while (StringUtils.isNotBlank((CharSequence)line)) {
                sb.append(line);
                line = bufferedReader.readLine();
            }
            Set tables = (Set)JSON.parseObject((String)sb.toString(), HashSet.class);
            UN_BUSINESS_TABLE.addAll(tables);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

