/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.common.enums;

import org.apache.commons.lang3.StringUtils;

public enum DataSourceTypeEnum {
    MYSQL("mysql", "com.mysql.jdbc.Driver", "com.mysql.cj.jdbc.Driver"),
    ORACLE("oracle", "oracle.jdbc.driver.OracleDriver");

    private String database;
    private String[] driverClassNames;

    private DataSourceTypeEnum(String database, String ... driverClassNames) {
        this.database = database;
        this.driverClassNames = driverClassNames;
    }

    public static DataSourceTypeEnum valueOfDriver(String driverClassName) {
        if (StringUtils.isBlank((CharSequence)driverClassName)) {
            return null;
        }
        for (DataSourceTypeEnum value : DataSourceTypeEnum.values()) {
            for (String className : value.driverClassNames) {
                if (!className.equals(driverClassName)) continue;
                return value;
            }
        }
        return null;
    }

    public static DataSourceTypeEnum valueOfDatabase(String database) {
        if (StringUtils.isBlank((CharSequence)database)) {
            return null;
        }
        for (DataSourceTypeEnum value : DataSourceTypeEnum.values()) {
            if (!value.database.equalsIgnoreCase(database)) continue;
            return value;
        }
        return null;
    }

    public String getDatabase() {
        return this.database;
    }

    public String[] getDriverClassNames() {
        return this.driverClassNames;
    }
}

