/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.service.serviceable.ServicableDataAuthService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="ServiceableDataAuthController", tags={"\u670d\u52a1\u6e90\u6570\u636e\u6743\u9650\u63a5\u53e3\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/nebula/servicableDataAuths"})
public class ServicableDataAuthController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicableDataAuthController.class);
    @Autowired
    private ServicableDataAuthService servicableDataAuthService;

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u53ef\u7528\u670d\u52a1\u6e90\u5217\u8868\uff0c\u652f\u6301\u5206\u9875\u4f46\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@ApiParam(name="name", value="\u53ef\u80fd\u7684\u670d\u52a1\u6e90\u6807\u8bc6\u540d\u79f0", required=false) @RequestParam(required=false, name="name") String name, @ApiParam(name="description", value="\u65b9\u6cd5\u4e2d\u6587\u63cf\u8ff0\uff08\u652f\u6301\u6a21\u7cca\u67e5\u8be2\uff09", required=false) @RequestParam(required=false, name="description") String description, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<JSONObject> page = this.servicableDataAuthService.findByConditions(pageable, name, description);
            return this.buildHttpResultW(page, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findFieldsByServicableNameAndAuthCode"})
    @ApiOperation(value="\u6839\u636e\u670d\u52a1\u6e90\u540d\u79f0\u3001\u6570\u636e\u6743\u9650\u7f16\u7801\uff0c\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u80fd\u770b\u89c1\u7684\u5b57\u6bb5\u4fe1\u606f", notes="\u6839\u636e\u670d\u52a1\u6e90\u540d\u79f0\u3001\u6570\u636e\u6743\u9650\u7f16\u7801\uff0c\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u80fd\u770b\u89c1\u7684\u5b57\u6bb5\u4fe1\u606f")
    public ResponseModel findFieldsByServicableNameAndAuthCode(@ApiParam(value="\u670d\u52a1\u6e90\u540d\u79f0", required=true) @RequestParam(name="servicableName") String servicableName, @ApiParam(value="\u6570\u636e\u6743\u9650\u7f16\u7801", required=true) @RequestParam(name="dataAuthCode") String dataAuthCode) {
        try {
            JSONArray fields = this.servicableDataAuthService.findFieldsByServicableNameAndAuthCode(servicableName, dataAuthCode);
            return this.buildHttpResultW((Iterable)fields, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

