/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.repository.dataview.DataSourceRepositoryCustom;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="DataSourceRepositoryImpl")
public class DataSourceRepositoryImpl
implements DataSourceRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<DataSourceEntity> findByConditions(DataSourceEntity dataSource, Pageable pageable) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        StringBuilder hql = new StringBuilder("select ds from DataSourceEntity ds where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from DataSourceEntity ds where 1=1 ");
        HashMap<String, String> parameters = new HashMap<String, String>();
        StringBuilder conditions = new StringBuilder();
        if (dataSource != null && StringUtils.isNotBlank((CharSequence)dataSource.getCode())) {
            parameters.put("code", dataSource.getCode());
            conditions.append(" and ds.code like concat(concat('%',:code),'%')");
        }
        if (StringUtils.isNotBlank((CharSequence)dataSource.getProjectName())) {
            conditions.append(" AND ds.projectName = :projectName ");
            parameters.put("projectName", dataSource.getProjectName());
        } else {
            conditions.append(" AND (ds.projectName = '' OR ds.projectName IS NULL)");
        }
        hql.append((CharSequence)conditions).append(" order by ds.createTime desc");
        countHql.append((CharSequence)conditions);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }
}

